/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.model.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.activiti.api.runtime.model.impl.ObjectValue;
import org.activiti.api.runtime.model.impl.ProcessVariablesMap;
import org.activiti.api.runtime.model.impl.ProcessVariablesMapTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

public class ProcessVariablesMapDeserializer
extends JsonDeserializer<ProcessVariablesMap<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessVariablesMapDeserializer.class);
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final ConversionService conversionService;

    public ProcessVariablesMapDeserializer(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ProcessVariablesMap<String, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ProcessVariablesMap<String, Object> map = new ProcessVariablesMap<String, Object>();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        node.fields().forEachRemaining(entry -> {
            String name = (String)entry.getKey();
            JsonNode entryValue = (JsonNode)entry.getValue();
            if (!entryValue.isNull()) {
                if (entryValue.get(TYPE) != null && entryValue.get(VALUE) != null) {
                    Class<?> clazz;
                    String type = entryValue.get(TYPE).textValue();
                    String value = entryValue.get(VALUE).asText();
                    Object result = this.conversionService.convert((Object)value, clazz = ProcessVariablesMapTypeRegistry.forType(type));
                    if (ObjectValue.class.isInstance(result)) {
                        result = ((ObjectValue)ObjectValue.class.cast(result)).getObject();
                    }
                    map.put(name, result);
                } else {
                    Object value = null;
                    try {
                        value = objectMapper.treeToValue((TreeNode)entryValue, Object.class);
                    }
                    catch (JsonProcessingException e) {
                        logger.error("Unexpected Json Processing Exception: ", (Throwable)e);
                    }
                    map.put(name, value);
                }
            } else {
                map.put(name, null);
            }
        });
        return map;
    }
}

