/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.model.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.activiti.api.runtime.model.impl.ObjectValue;
import org.activiti.api.runtime.model.impl.ProcessVariableValue;
import org.activiti.api.runtime.model.impl.ProcessVariablesMap;
import org.activiti.api.runtime.model.impl.ProcessVariablesMapTypeRegistry;
import org.springframework.core.convert.ConversionService;

public class ProcessVariablesMapSerializer
extends StdSerializer<ProcessVariablesMap<String, Object>> {
    private static final long serialVersionUID = 1L;
    private final ConversionService conversionService;

    public ProcessVariablesMapSerializer(ConversionService conversionService) {
        super(ProcessVariablesMap.class, true);
        this.conversionService = conversionService;
    }

    public void serialize(ProcessVariablesMap<String, Object> processVariablesMap, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        HashMap<String, ProcessVariableValue> map = new HashMap<String, ProcessVariableValue>();
        for (Map.Entry entry : processVariablesMap.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            map.put(name, this.buildProcessVariableValue(value));
        }
        gen.writeObject(map);
    }

    private ProcessVariableValue buildProcessVariableValue(Object value) {
        ProcessVariableValue variableValue = null;
        if (value != null) {
            Class<?> entryValueClass = value.getClass();
            String entryType = this.resolveEntryType(entryValueClass, value);
            if ("object".equals(entryType)) {
                value = new ObjectValue(value);
            }
            String entryValue = (String)this.conversionService.convert(value, String.class);
            variableValue = new ProcessVariableValue(entryType, entryValue);
        }
        return variableValue;
    }

    private String resolveEntryType(Class<?> clazz, Object value) {
        Class<Object> entryType = ProcessVariablesMapTypeRegistry.isScalarType(clazz) ? clazz : ProcessVariablesMapTypeRegistry.getContainerType(clazz, value).orElse(ObjectValue.class);
        return ProcessVariablesMapTypeRegistry.forClass(entryType);
    }
}

