/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.model.impl;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProcessVariableValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type;
    private String value;

    ProcessVariableValue() {
    }

    private ProcessVariableValue(Builder builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    public ProcessVariableValue(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessVariableValue other = (ProcessVariableValue)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(2);
        result.put("type", this.type);
        result.put("value", this.value);
        return result;
    }

    public String toJson() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"type\":\"").append(this.type).append("\",\"value\":").append(Optional.ofNullable(this.value).map(this::escape).orElse("null")).append("}");
        return builder.toString();
    }

    public String toString() {
        return this.toJson();
    }

    private String escape(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                builder.append("\\'");
                continue;
            }
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                builder.append(String.format("\\u%04x", c));
                continue;
            }
            builder.append(c);
        }
        builder.append("\"");
        return builder.toString();
    }

    public static ITypeStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements ITypeStage,
    IValueStage,
    IBuildStage {
        private String type;
        private String value;

        private Builder() {
        }

        @Override
        public IValueStage type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public IBuildStage value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ProcessVariableValue build() {
            return new ProcessVariableValue(this);
        }
    }

    public static interface IBuildStage {
        public ProcessVariableValue build();
    }

    public static interface IValueStage {
        public IBuildStage value(String var1);
    }

    public static interface ITypeStage {
        public IValueStage type(String var1);
    }
}

