/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.model.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.ProcessVariablesMap;

public class IntegrationContextImpl
implements IntegrationContext {
    private String id;
    private ProcessVariablesMap<String, Object> inBoundVariables = new ProcessVariablesMap();
    private ProcessVariablesMap<String, Object> outBoundVariables = new ProcessVariablesMap();
    private String processInstanceId;
    private String parentProcessInstanceId;
    private String rootProcessInstanceId;
    private String processDefinitionId;
    private String executionId;
    private String processDefinitionKey;
    private Integer processDefinitionVersion;
    private String businessKey;
    private String clientId;
    private String clientName;
    private String clientType;
    private String appVersion;
    private String connectorType;
    private Boolean ephemeralVariables;

    public IntegrationContextImpl() {
        this.id = UUID.randomUUID().toString();
    }

    public IntegrationContextImpl(IntegrationContext other) {
        this.id = other.getId();
        this.inBoundVariables.putAll(other.getInBoundVariables());
        this.outBoundVariables.putAll(other.getOutBoundVariables());
        this.processInstanceId = other.getProcessInstanceId();
        this.parentProcessInstanceId = other.getParentProcessInstanceId();
        this.rootProcessInstanceId = other.getRootProcessInstanceId();
        this.processDefinitionId = other.getProcessDefinitionId();
        this.executionId = other.getExecutionId();
        this.processDefinitionKey = other.getProcessDefinitionKey();
        this.processDefinitionVersion = other.getProcessDefinitionVersion();
        this.businessKey = other.getBusinessKey();
        this.clientId = other.getClientId();
        this.clientName = other.getClientName();
        this.clientType = other.getClientType();
        this.appVersion = other.getAppVersion();
        this.connectorType = other.getConnectorType();
        this.ephemeralVariables = other.hasEphemeralVariables();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public void setConnectorType(String connectorType) {
        this.connectorType = connectorType;
    }

    public Map<String, Object> getInBoundVariables() {
        return this.inBoundVariables;
    }

    public void addInBoundVariables(Map<String, Object> inboundVariables) {
        this.inBoundVariables.putAll(inboundVariables);
    }

    public void addInBoundVariable(String name, Object value) {
        this.inBoundVariables.put(name, value);
    }

    public Map<String, Object> getOutBoundVariables() {
        return this.outBoundVariables;
    }

    public void addOutBoundVariable(String name, Object value) {
        this.outBoundVariables.put(name, value);
    }

    public void addOutBoundVariables(Map<String, Object> variables) {
        this.outBoundVariables.putAll(variables);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setEphemeralVariables(Boolean ephemeralVariables) {
        this.ephemeralVariables = ephemeralVariables;
    }

    public int hashCode() {
        return Objects.hash(this.appVersion, this.businessKey, this.clientId, this.clientName, this.clientType, this.connectorType, this.executionId, this.id, this.inBoundVariables, this.outBoundVariables, this.parentProcessInstanceId, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionVersion, this.processInstanceId, this.rootProcessInstanceId, this.ephemeralVariables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegrationContextImpl other = (IntegrationContextImpl)obj;
        return Objects.equals(this.appVersion, other.appVersion) && Objects.equals(this.businessKey, other.businessKey) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientName, other.clientName) && Objects.equals(this.clientType, other.clientType) && Objects.equals(this.connectorType, other.connectorType) && Objects.equals(this.executionId, other.executionId) && Objects.equals(this.id, other.id) && Objects.equals(this.inBoundVariables, other.inBoundVariables) && Objects.equals(this.outBoundVariables, other.outBoundVariables) && Objects.equals(this.parentProcessInstanceId, other.parentProcessInstanceId) && Objects.equals(this.processDefinitionId, other.processDefinitionId) && Objects.equals(this.processDefinitionKey, other.processDefinitionKey) && Objects.equals(this.processDefinitionVersion, other.processDefinitionVersion) && Objects.equals(this.processInstanceId, other.processInstanceId) && Objects.equals(this.rootProcessInstanceId, other.rootProcessInstanceId) && Objects.equals(this.ephemeralVariables, other.ephemeralVariables);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntegrationContextImpl [id=").append(this.id).append(", inboundVariablesKeys=").append(this.inBoundVariables != null ? this.printKeys(this.inBoundVariables.keySet()) : null).append(", outBoundVariableKeys=").append(this.outBoundVariables != null ? this.printKeys(this.outBoundVariables.keySet()) : null).append(", rootProcessInstanceId=").append(this.rootProcessInstanceId).append(", processInstanceId=").append(this.processInstanceId).append(", parentProcessInstanceId=").append(this.parentProcessInstanceId).append(", processDefinitionId=").append(this.processDefinitionId).append(", executionId=").append(this.executionId).append(", processDefinitionKey=").append(this.processDefinitionKey).append(", processDefinitionVersion=").append(this.processDefinitionVersion).append(", businessKey=").append(this.businessKey).append(", clientId=").append(this.clientId).append(", clientName=").append(this.clientName).append(", clientType=").append(this.clientType).append(", appVersion=").append(this.appVersion).append(", connectorType=").append(this.connectorType).append(", ephemeralVariables=").append(this.ephemeralVariables).append("]");
        return builder.toString();
    }

    private String printKeys(Set<String> keys) {
        return Stream.ofNullable(keys).map(String::valueOf).collect(Collectors.joining(", "));
    }

    public <T> T getInBoundVariable(String name) {
        return Optional.ofNullable(this.inBoundVariables).map(it -> this.inBoundVariables.get(name)).orElse(null);
    }

    public <T> T getInBoundVariable(String name, Class<T> type) {
        return Optional.ofNullable(this.inBoundVariables).map(it -> this.inBoundVariables.get(name)).orElse(null);
    }

    public <T> T getOutBoundVariable(String name) {
        return Optional.ofNullable(this.outBoundVariables).map(it -> it.get(name)).orElse(null);
    }

    public <T> T getOutBoundVariable(String name, Class<T> type) {
        return Optional.ofNullable(this.outBoundVariables).map(it -> it.get(name)).orElse(null);
    }

    @JsonProperty(value="ephemeralVariables")
    public boolean hasEphemeralVariables() {
        return Boolean.TRUE.equals(this.ephemeralVariables);
    }

    public void clearOutBoundVariables() {
        this.outBoundVariables.clear();
    }

    public void clearInBoundVariables() {
        this.inBoundVariables.clear();
    }
}

