/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.payloads;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.activiti.api.model.shared.Payload;

public class ReceiveMessagePayload
implements Payload {
    private final String id;
    private String name;
    private String correlationKey;
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();

    public ReceiveMessagePayload() {
        this.id = UUID.randomUUID().toString();
    }

    public ReceiveMessagePayload(String name, String correlationKey, Map<String, Object> variables) {
        this();
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        this.correlationKey = correlationKey;
        this.variables = variables;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.correlationKey, this.variables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiveMessagePayload other = (ReceiveMessagePayload)obj;
        return Objects.equals(this.correlationKey, other.correlationKey) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.variables, other.variables);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReceiveMessagePayload [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", correlationKey=");
        builder.append(this.correlationKey);
        builder.append(", variables=");
        builder.append(this.variables);
        builder.append("]");
        return builder.toString();
    }
}

