/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.builders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.api.process.model.payloads.MessageEventPayload;

public class MessageEventPayloadBuilder {
    private String name;
    private String correlationKey;
    private String businessKey;
    private Map<String, Object> variables;

    public static MessageEventPayloadBuilder from(MessageEventPayload messagePayload) {
        Objects.requireNonNull(messagePayload, "messagePayload must not be null");
        return new MessageEventPayloadBuilder().withName(messagePayload.getName()).withBusinessKey(messagePayload.getBusinessKey()).withCorrelationKey(messagePayload.getCorrelationKey()).withVariables(messagePayload.getVariables());
    }

    public static MessageEventPayloadBuilder messageEvent(String name) {
        return new MessageEventPayloadBuilder().withName(name);
    }

    public MessageEventPayloadBuilder withName(String name) {
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        return this;
    }

    public MessageEventPayloadBuilder withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public MessageEventPayloadBuilder withVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public MessageEventPayloadBuilder withCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    public MessageEventPayloadBuilder withBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public MessageEventPayload build() {
        return new MessageEventPayload(this.name, this.correlationKey, this.businessKey, this.variables);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageEventPayloadBuilder [name=");
        builder.append(this.name);
        builder.append(", correlationKey=");
        builder.append(this.correlationKey);
        builder.append(", businessKey=");
        builder.append(this.businessKey);
        builder.append(", variables=");
        builder.append(this.variables);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.correlationKey, this.name, this.variables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageEventPayloadBuilder other = (MessageEventPayloadBuilder)obj;
        return Objects.equals(this.correlationKey, other.correlationKey) && Objects.equals(this.businessKey, other.businessKey) && Objects.equals(this.name, other.name) && Objects.equals(this.variables, other.variables);
    }
}

