/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.builders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.api.process.model.payloads.StartMessagePayload;

public class StartMessagePayloadBuilder {
    private String name;
    private String businessKey;
    private Map<String, Object> variables;

    public static StartMessagePayloadBuilder from(StartMessagePayload messagePayload) {
        Objects.requireNonNull(messagePayload, "messagePayload must not be null");
        return new StartMessagePayloadBuilder().withName(messagePayload.getName()).withBusinessKey(messagePayload.getBusinessKey()).withVariables(messagePayload.getVariables());
    }

    public static StartMessagePayloadBuilder start(String name) {
        return new StartMessagePayloadBuilder().withName(name);
    }

    public StartMessagePayloadBuilder withName(String name) {
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        return this;
    }

    public StartMessagePayloadBuilder withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public StartMessagePayloadBuilder withVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public StartMessagePayloadBuilder withBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public StartMessagePayload build() {
        return new StartMessagePayload(this.name, this.businessKey, this.variables);
    }
}

