/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.Objects;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.runtime.api.impl.ExtensionsVariablesMappingProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationContextBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationContextBuilder.class);
    private final ExtensionsVariablesMappingProvider inboundVariablesProvider;
    private final ExpressionManager expressionManager;

    public IntegrationContextBuilder(ExtensionsVariablesMappingProvider inboundVariablesProvider, ExpressionManager expressionManager) {
        this.inboundVariablesProvider = inboundVariablesProvider;
        this.expressionManager = expressionManager;
    }

    public IntegrationContext from(IntegrationContextEntity integrationContextEntity, DelegateExecution execution) {
        IntegrationContextImpl integrationContext = this.buildFromExecution(execution);
        integrationContext.setId(integrationContextEntity.getId());
        return integrationContext;
    }

    public IntegrationContext from(DelegateExecution execution) {
        return this.buildFromExecution(execution);
    }

    private IntegrationContextImpl buildFromExecution(DelegateExecution execution) {
        ServiceTask serviceTask;
        IntegrationContextImpl integrationContext = new IntegrationContextImpl();
        integrationContext.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setBusinessKey(execution.getProcessInstanceBusinessKey());
        integrationContext.setClientId(execution.getCurrentActivityId());
        integrationContext.setExecutionId(execution.getId());
        if (ExecutionEntity.class.isInstance(execution)) {
            ProcessDefinition processDefinition;
            ExecutionContext executionContext = new ExecutionContext((ExecutionEntity)ExecutionEntity.class.cast(execution));
            ExecutionEntity processInstance = executionContext.getProcessInstance();
            if (processInstance != null) {
                integrationContext.setParentProcessInstanceId(processInstance.getParentProcessInstanceId());
                integrationContext.setAppVersion(Objects.toString(processInstance.getAppVersion(), "1"));
            }
            if ((processDefinition = executionContext.getProcessDefinition()) != null) {
                integrationContext.setProcessDefinitionKey(processDefinition.getKey());
                integrationContext.setProcessDefinitionVersion(Integer.valueOf(processDefinition.getVersion()));
            }
        }
        if ((serviceTask = (ServiceTask)execution.getCurrentFlowElement()) != null) {
            integrationContext.setConnectorType(serviceTask.getImplementation());
            integrationContext.setClientName(this.resolveServiceTaskNameExpression(serviceTask, execution));
            integrationContext.setClientType(ServiceTask.class.getSimpleName());
        }
        integrationContext.addInBoundVariables(this.inboundVariablesProvider.calculateInputVariables(execution));
        return integrationContext;
    }

    protected String resolveServiceTaskNameExpression(ServiceTask serviceTask, DelegateExecution execution) {
        String clientName = serviceTask.getName();
        if (StringUtils.isNotEmpty((CharSequence)clientName)) {
            try {
                return (String)this.expressionManager.createExpression(clientName).getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                LOGGER.warn("property not found in service task name expression " + e.getMessage());
            }
        }
        return clientName;
    }
}

