/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.MappingExecutionContext;
import org.activiti.engine.impl.bpmn.behavior.VariablesCalculator;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ProcessInstanceHelper;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.SimpleMapExpressionEvaluator;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.VariableParsingService;
import org.activiti.spring.process.variable.VariableValidationService;

public class ProcessVariablesInitiator
extends ProcessInstanceHelper {
    private ProcessExtensionService processExtensionService;
    private final VariableParsingService variableParsingService;
    private final VariableValidationService variableValidationService;
    private VariablesCalculator variablesCalculator;
    private ExpressionResolver expressionResolver;

    public ProcessVariablesInitiator(ProcessExtensionService processExtensionService, VariableParsingService variableParsingService, VariableValidationService variableValidationService, VariablesCalculator variablesCalculator, ExpressionResolver expressionResolver) {
        this.processExtensionService = processExtensionService;
        this.variableParsingService = variableParsingService;
        this.variableValidationService = variableValidationService;
        this.variablesCalculator = variablesCalculator;
        this.expressionResolver = expressionResolver;
    }

    public Map<String, Object> calculateVariablesFromExtensionFile(ProcessDefinition processDefinition, Map<String, Object> variables) {
        Map<String, Object> processedVariables = new HashMap<String, Object>();
        if (this.processExtensionService.hasExtensionsFor(processDefinition)) {
            Extension processExtension = this.processExtensionService.getExtensionsFor(processDefinition);
            Map variableDefinitionMap = processExtension.getProperties();
            processedVariables = this.processVariables(variables, variableDefinitionMap);
            Set<String> missingRequiredVars = this.checkRequiredVariables(processedVariables, variableDefinitionMap);
            if (!missingRequiredVars.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' without required variables - " + String.join((CharSequence)", ", missingRequiredVars));
            }
            Set<String> varsWithMismatchedTypes = this.validateVariablesAgainstDefinitions(processedVariables, variableDefinitionMap);
            if (!varsWithMismatchedTypes.isEmpty()) {
                throw new ActivitiException("Can't start process '" + processDefinition.getKey() + "' as variables fail type validation - " + String.join((CharSequence)", ", varsWithMismatchedTypes));
            }
        }
        return processedVariables;
    }

    public Map<String, Object> calculateOutputVariables(Map<String, Object> variables, ProcessDefinition processDefinition, FlowElement initialFlowElement) {
        Map<String, Object> processVariables = variables;
        if (this.processExtensionService.hasExtensionsFor(processDefinition)) {
            Map<String, Object> calculateOutPutVariables = this.variablesCalculator.calculateOutPutVariables(MappingExecutionContext.buildMappingExecutionContext((String)processDefinition.getId(), (String)initialFlowElement.getId()), variables);
            if (!calculateOutPutVariables.isEmpty()) {
                processVariables = calculateOutPutVariables;
            }
            processVariables = this.calculateVariablesFromExtensionFile(processDefinition, processVariables);
        }
        return processVariables;
    }

    private Map<String, Object> processVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashMap<String, Object> newVarsMap = new HashMap<String, Object>(Optional.ofNullable(variables).orElse(Collections.emptyMap()));
        HashMap varsWithExpressions = new HashMap();
        variableDefinitionMap.forEach((k, v) -> {
            if (!newVarsMap.containsKey(v.getName()) && v.getValue() != null) {
                Object value = this.createDefaultVariableValue((VariableDefinition)v);
                if (this.expressionResolver.containsExpression(value) || value instanceof ObjectNode) {
                    varsWithExpressions.put(v.getName(), value);
                } else {
                    newVarsMap.put(v.getName(), value);
                }
            }
        });
        if (!varsWithExpressions.isEmpty()) {
            newVarsMap.putAll(this.expressionResolver.resolveExpressionsMap(new SimpleMapExpressionEvaluator(newVarsMap), varsWithExpressions));
        }
        return newVarsMap;
    }

    private Object createDefaultVariableValue(VariableDefinition variableDefinition) {
        return this.variableParsingService.parse(variableDefinition);
    }

    private Set<String> checkRequiredVariables(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> missingRequiredVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (!variables.containsKey(v.getName()) && v.isRequired()) {
                missingRequiredVars.add(v.getName());
            }
        });
        return missingRequiredVars;
    }

    private Set<String> validateVariablesAgainstDefinitions(Map<String, Object> variables, Map<String, VariableDefinition> variableDefinitionMap) {
        HashSet<String> mismatchedVars = new HashSet<String>();
        variableDefinitionMap.forEach((k, v) -> {
            if (variables.containsKey(v.getName()) && !this.variableValidationService.validate(variables.get(v.getName()), v)) {
                mismatchedVars.add(v.getName());
            }
        });
        return mismatchedVars;
    }

    public void startProcessInstance(ExecutionEntity processInstance, CommandContext commandContext, Map<String, Object> variables, FlowElement initialFlowElement, Map<String, Object> transientVariables) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition((String)processInstance.getProcessDefinitionId());
        Map<String, Object> calculatedVariables = this.calculateOutputVariables(variables, processDefinition, initialFlowElement);
        super.startProcessInstance(processInstance, commandContext, calculatedVariables, initialFlowElement, transientVariables);
    }
}

