/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.event.internal;

import java.util.List;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.model.shared.event.VariableUpdatedEvent;
import org.activiti.api.runtime.shared.events.VariableEventListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiVariableEvent;
import org.activiti.engine.delegate.event.ActivitiVariableUpdatedEvent;
import org.activiti.runtime.api.event.impl.ToVariableUpdatedConverter;
import org.activiti.runtime.api.event.internal.VariableEventFilter;

public class VariableUpdatedListenerDelegate
implements ActivitiEventListener {
    private final List<VariableEventListener<VariableUpdatedEvent>> listeners;
    private final ToVariableUpdatedConverter converter;
    private final VariableEventFilter variableEventFilter;

    public VariableUpdatedListenerDelegate(List<VariableEventListener<VariableUpdatedEvent>> listeners, ToVariableUpdatedConverter converter, VariableEventFilter variableEventFilter) {
        this.listeners = listeners;
        this.converter = converter;
        this.variableEventFilter = variableEventFilter;
    }

    public void onEvent(ActivitiEvent event) {
        ActivitiVariableUpdatedEvent internalEvent;
        if (event instanceof ActivitiVariableUpdatedEvent && this.variableEventFilter.shouldEmmitEvent((ActivitiVariableEvent)(internalEvent = (ActivitiVariableUpdatedEvent)event))) {
            this.converter.from(internalEvent).ifPresent(convertedEvent -> {
                if (this.listeners != null) {
                    for (VariableEventListener<VariableUpdatedEvent> listener : this.listeners) {
                        listener.onEvent((RuntimeEvent)convertedEvent);
                    }
                }
            });
        }
    }

    public boolean isFailOnException() {
        return false;
    }
}

