/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.event.internal;

import java.util.List;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.model.shared.event.VariableCreatedEvent;
import org.activiti.api.runtime.shared.events.VariableEventListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiVariableEvent;
import org.activiti.runtime.api.event.impl.ToVariableCreatedConverter;
import org.activiti.runtime.api.event.internal.VariableEventFilter;

public class VariableCreatedListenerDelegate
implements ActivitiEventListener {
    private final List<VariableEventListener<VariableCreatedEvent>> listeners;
    private final ToVariableCreatedConverter converter;
    private final VariableEventFilter variableEventFilter;

    public VariableCreatedListenerDelegate(List<VariableEventListener<VariableCreatedEvent>> listeners, ToVariableCreatedConverter converter, VariableEventFilter variableEventFilter) {
        this.listeners = listeners;
        this.converter = converter;
        this.variableEventFilter = variableEventFilter;
    }

    public void onEvent(ActivitiEvent event) {
        ActivitiVariableEvent internalEvent;
        if (event instanceof ActivitiVariableEvent && this.variableEventFilter.shouldEmmitEvent(internalEvent = (ActivitiVariableEvent)event)) {
            this.converter.from(internalEvent).ifPresent(convertedEvent -> {
                if (this.listeners != null) {
                    for (VariableEventListener<VariableCreatedEvent> listener : this.listeners) {
                        listener.onEvent((RuntimeEvent)convertedEvent);
                    }
                }
            });
        }
    }

    public boolean isFailOnException() {
        return false;
    }
}

