/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class VariableNameValidator {
    public static String regexPattern = "(?i)[a-z][a-z0-9_]*";

    public boolean validate(String name) {
        return StringUtils.hasLength((String)name) && Pattern.compile(regexPattern).matcher(name).matches();
    }

    public Set<String> validateVariables(Map<String, Object> variables) {
        HashSet<String> mismatchedVars = new HashSet<String>();
        if (variables != null && !variables.isEmpty()) {
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                if (this.validate(variable.getKey())) continue;
                mismatchedVars.add(variable.getKey());
            }
        }
        return mismatchedVars;
    }
}

