/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.shared.security;

import java.util.List;
import org.activiti.api.runtime.shared.security.PrincipalGroupsProvider;
import org.activiti.api.runtime.shared.security.PrincipalIdentityProvider;
import org.activiti.api.runtime.shared.security.PrincipalRolesProvider;
import org.activiti.api.runtime.shared.security.SecurityContextPrincipalProvider;
import org.activiti.api.runtime.shared.security.SecurityManager;

public abstract class AbstractSecurityManager
implements SecurityManager {
    private static final String INVALID_AUTHENTICATED_PRINCIPAL = "Invalid authenticated principal";
    private final SecurityContextPrincipalProvider securityContextPrincipalProvider;
    private final PrincipalIdentityProvider principalIdentityProvider;
    private final PrincipalGroupsProvider principalGroupsProvider;
    private final PrincipalRolesProvider principalRolesProvider;

    public AbstractSecurityManager(SecurityContextPrincipalProvider securityContextPrincipalProvider, PrincipalIdentityProvider principalIdentityProvider, PrincipalGroupsProvider principalGroupsProvider, PrincipalRolesProvider principalRolesProvider) {
        this.securityContextPrincipalProvider = securityContextPrincipalProvider;
        this.principalIdentityProvider = principalIdentityProvider;
        this.principalGroupsProvider = principalGroupsProvider;
        this.principalRolesProvider = principalRolesProvider;
    }

    @Override
    public String getAuthenticatedUserId() {
        return this.securityContextPrincipalProvider.getCurrentPrincipal().map(this.principalIdentityProvider::getUserId).orElseThrow(this::securityException);
    }

    @Override
    public List<String> getAuthenticatedUserGroups() {
        return this.securityContextPrincipalProvider.getCurrentPrincipal().map(this.principalGroupsProvider::getGroups).orElseThrow(this::securityException);
    }

    @Override
    public List<String> getAuthenticatedUserRoles() {
        return this.securityContextPrincipalProvider.getCurrentPrincipal().map(this.principalRolesProvider::getRoles).orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException(INVALID_AUTHENTICATED_PRINCIPAL);
    }
}

