/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.task.conf.impl;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.impl.TaskCandidateGroupImpl;
import org.activiti.api.task.model.impl.TaskCandidateUserImpl;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.api.task.model.payloads.ClaimTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskPayload;
import org.activiti.api.task.model.payloads.DeleteTaskPayload;
import org.activiti.api.task.model.payloads.GetTaskVariablesPayload;
import org.activiti.api.task.model.payloads.GetTasksPayload;
import org.activiti.api.task.model.payloads.ReleaseTaskPayload;
import org.activiti.api.task.model.payloads.SaveTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.model.results.TaskResult;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class TaskModelAutoConfiguration {
    @Bean
    public Module customizeTaskModelObjectMapper() {
        SimpleModule module = new SimpleModule("mapTaskRuntimeInterfaces", Version.unknownVersion());
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver(){

            public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
                return this.findTypeMapping(config, typeDesc.getType());
            }
        };
        resolver.addMapping(Task.class, TaskImpl.class);
        resolver.addMapping(TaskCandidateUser.class, TaskCandidateUserImpl.class);
        resolver.addMapping(TaskCandidateGroup.class, TaskCandidateGroupImpl.class);
        module.registerSubtypes(new NamedType[]{new NamedType(TaskResult.class, TaskResult.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(ClaimTaskPayload.class, ClaimTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(CompleteTaskPayload.class, CompleteTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(SaveTaskPayload.class, SaveTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(CreateTaskPayload.class, CreateTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(DeleteTaskPayload.class, DeleteTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(GetTasksPayload.class, GetTasksPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(GetTaskVariablesPayload.class, GetTaskVariablesPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(ReleaseTaskPayload.class, ReleaseTaskPayload.class.getSimpleName())});
        module.registerSubtypes(new NamedType[]{new NamedType(UpdateTaskPayload.class, UpdateTaskPayload.class.getSimpleName())});
        module.setAbstractTypes(resolver);
        return module;
    }
}

