/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.task.model.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.activiti.api.task.model.payloads.AssignTasksPayload;

public class AssignTasksPayloadBuilder {
    private List<String> taskIds = new ArrayList<String>();
    private String assignee;

    public AssignTasksPayloadBuilder withAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public AssignTasksPayloadBuilder withTaskIds(List<String> taskIds) {
        this.taskIds = Objects.requireNonNullElseGet(taskIds, ArrayList::new);
        return this;
    }

    public AssignTasksPayloadBuilder withTaskId(String taskId) {
        this.taskIds.add(taskId);
        return this;
    }

    public AssignTasksPayload build() {
        return new AssignTasksPayload(this.taskIds, this.assignee);
    }
}

