/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.event.impl;

import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.runtime.events.TaskCancelledEvent;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.runtime.api.event.impl.EventConverter;
import org.activiti.runtime.api.event.impl.TaskCancelledImpl;
import org.activiti.runtime.api.model.impl.APITaskConverter;

public class ToTaskCancelledConverter
implements EventConverter<TaskCancelledEvent, ActivitiEntityEvent> {
    private APITaskConverter taskConverter;

    public ToTaskCancelledConverter(APITaskConverter taskConverter) {
        this.taskConverter = taskConverter;
    }

    public Optional<TaskCancelledEvent> from(ActivitiEntityEvent internalEvent) {
        TaskCancelledImpl event = null;
        if (this.isTaskCancelled(internalEvent)) {
            TaskEntity taskEntity = (TaskEntity)internalEvent.getEntity();
            org.activiti.api.task.model.Task task = this.taskConverter.from((Task)taskEntity, Task.TaskStatus.CANCELLED);
            String reason = internalEvent.getReason();
            event = new TaskCancelledImpl(task, reason);
        }
        return Optional.ofNullable(event);
    }

    private boolean isTaskCancelled(ActivitiEntityEvent internalEvent) {
        return internalEvent.getEntity() != null && internalEvent.getEntity() instanceof TaskEntity && ((TaskEntity)internalEvent.getEntity()).isCanceled();
    }
}

