/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.util;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.child.ActivitiEventListenerParser;
import org.activiti.bpmn.converter.child.ActivitiFailedjobRetryParser;
import org.activiti.bpmn.converter.child.ActivitiMapExceptionParser;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.child.CancelEventDefinitionParser;
import org.activiti.bpmn.converter.child.CompensateEventDefinitionParser;
import org.activiti.bpmn.converter.child.ConditionExpressionParser;
import org.activiti.bpmn.converter.child.DataInputAssociationParser;
import org.activiti.bpmn.converter.child.DataOutputAssociationParser;
import org.activiti.bpmn.converter.child.DataStateParser;
import org.activiti.bpmn.converter.child.DocumentationParser;
import org.activiti.bpmn.converter.child.ErrorEventDefinitionParser;
import org.activiti.bpmn.converter.child.ExecutionListenerParser;
import org.activiti.bpmn.converter.child.FieldExtensionParser;
import org.activiti.bpmn.converter.child.FlowNodeRefParser;
import org.activiti.bpmn.converter.child.FormPropertyParser;
import org.activiti.bpmn.converter.child.IOSpecificationParser;
import org.activiti.bpmn.converter.child.MessageEventDefinitionParser;
import org.activiti.bpmn.converter.child.SignalEventDefinitionParser;
import org.activiti.bpmn.converter.child.TaskListenerParser;
import org.activiti.bpmn.converter.child.TerminateEventDefinitionParser;
import org.activiti.bpmn.converter.child.TimeCycleParser;
import org.activiti.bpmn.converter.child.TimeDateParser;
import org.activiti.bpmn.converter.child.TimeDurationParser;
import org.activiti.bpmn.converter.child.TimerEventDefinitionParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceParser;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SequenceFlow;
import org.apache.commons.lang3.StringUtils;

public class BpmnXMLUtil
implements BpmnXMLConstants {
    private static Map<String, BaseChildElementParser> genericChildParserMap = new HashMap<String, BaseChildElementParser>();

    private static void addGenericParser(BaseChildElementParser parser) {
        genericChildParserMap.put(parser.getElementName(), parser);
    }

    public static void addXMLLocation(BaseElement element, XMLStreamReader xtr) {
        Location location = xtr.getLocation();
        element.setXmlRowNumber(location.getLineNumber());
        element.setXmlColumnNumber(location.getColumnNumber());
    }

    public static void addXMLLocation(GraphicInfo graphicInfo, XMLStreamReader xtr) {
        Location location = xtr.getLocation();
        graphicInfo.setXmlRowNumber(location.getLineNumber());
        graphicInfo.setXmlColumnNumber(location.getColumnNumber());
    }

    public static void parseChildElements(String elementName, BaseElement parentElement, XMLStreamReader xtr, BpmnModel model) throws Exception {
        BpmnXMLUtil.parseChildElements(elementName, parentElement, xtr, null, model);
    }

    public static void parseChildElements(String elementName, BaseElement parentElement, XMLStreamReader xtr, Map<String, BaseChildElementParser> childParsers, BpmnModel model) throws Exception {
        HashMap<String, BaseChildElementParser> localParserMap = new HashMap<String, BaseChildElementParser>(genericChildParserMap);
        if (childParsers != null) {
            localParserMap.putAll(childParsers);
        }
        boolean inExtensionElements = false;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if ("extensionElements".equals(xtr.getLocalName())) {
                    inExtensionElements = true;
                    continue;
                }
                if (localParserMap.containsKey(xtr.getLocalName())) {
                    BaseChildElementParser childParser = (BaseChildElementParser)localParserMap.get(xtr.getLocalName());
                    if (inExtensionElements && !childParser.accepts(parentElement)) {
                        ExtensionElement extensionElement = BpmnXMLUtil.parseExtensionElement(xtr);
                        parentElement.addExtensionElement(extensionElement);
                        continue;
                    }
                    ((BaseChildElementParser)localParserMap.get(xtr.getLocalName())).parseChildElement(xtr, parentElement, model);
                    continue;
                }
                if (!inExtensionElements) continue;
                ExtensionElement extensionElement = BpmnXMLUtil.parseExtensionElement(xtr);
                parentElement.addExtensionElement(extensionElement);
                continue;
            }
            if (!xtr.isEndElement()) continue;
            if ("extensionElements".equals(xtr.getLocalName())) {
                inExtensionElements = false;
                continue;
            }
            if (!elementName.equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }

    public static ExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(xtr.getLocalName());
        BpmnXMLUtil.addXMLLocation((BaseElement)extensionElement, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        for (int i = 0; i < xtr.getAttributeCount(); ++i) {
            ExtensionAttribute extensionAttribute = new ExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            extensionElement.addAttribute(extensionAttribute);
        }
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters() || 12 == xtr.getEventType()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                if (StringUtils.isBlank((CharSequence)extensionElement.getElementText())) {
                    extensionElement.setElementText(xtr.getText());
                    continue;
                }
                extensionElement.setElementText(extensionElement.getElementText().concat(xtr.getText()));
                continue;
            }
            if (xtr.isStartElement()) {
                ExtensionElement childExtensionElement = BpmnXMLUtil.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            if (extensionElement.getElementText() != null) {
                extensionElement.setElementText(extensionElement.getElementText().trim());
            }
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    public static void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value) && !"null".equalsIgnoreCase(value)) {
            xtw.writeAttribute(attributeName, value);
        }
    }

    public static void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", attributeName, value);
        }
    }

    public static boolean writeExtensionElements(BaseElement baseElement, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements(baseElement, didWriteExtensionStartElement, null, xtw);
        return didWriteExtensionStartElement;
    }

    public static boolean writeExtensionElements(BaseElement baseElement, boolean didWriteExtensionStartElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (!baseElement.getExtensionElements().isEmpty()) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, String>();
            }
            for (List extensionElements : baseElement.getExtensionElements().values()) {
                for (ExtensionElement extensionElement : extensionElements) {
                    BpmnXMLUtil.writeExtensionElement(extensionElement, namespaceMap, xtw);
                }
            }
        }
        return didWriteExtensionStartElement;
    }

    protected static void writeExtensionElement(ExtensionElement extensionElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)extensionElement.getName())) {
            HashMap<String, String> localNamespaceMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespace())) {
                if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespacePrefix())) {
                    xtw.writeStartElement(extensionElement.getNamespacePrefix(), extensionElement.getName(), extensionElement.getNamespace());
                    if (!namespaceMap.containsKey(extensionElement.getNamespacePrefix()) || !namespaceMap.get(extensionElement.getNamespacePrefix()).equals(extensionElement.getNamespace())) {
                        xtw.writeNamespace(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        namespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        localNamespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                    }
                } else {
                    xtw.writeStartElement(extensionElement.getNamespace(), extensionElement.getName());
                }
            } else {
                xtw.writeStartElement(extensionElement.getName());
            }
            for (List attributes : extensionElement.getAttributes().values()) {
                for (ExtensionAttribute attribute : attributes) {
                    if (!StringUtils.isNotEmpty((CharSequence)attribute.getName()) || attribute.getValue() == null) continue;
                    if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespace())) {
                        if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespacePrefix())) {
                            if (!namespaceMap.containsKey(attribute.getNamespacePrefix()) || !namespaceMap.get(attribute.getNamespacePrefix()).equals(attribute.getNamespace())) {
                                xtw.writeNamespace(attribute.getNamespacePrefix(), attribute.getNamespace());
                                namespaceMap.put(attribute.getNamespacePrefix(), attribute.getNamespace());
                            }
                            xtw.writeAttribute(attribute.getNamespacePrefix(), attribute.getNamespace(), attribute.getName(), attribute.getValue());
                            continue;
                        }
                        xtw.writeAttribute(attribute.getNamespace(), attribute.getName(), attribute.getValue());
                        continue;
                    }
                    xtw.writeAttribute(attribute.getName(), attribute.getValue());
                }
            }
            if (extensionElement.getElementText() != null) {
                xtw.writeCData(extensionElement.getElementText());
            } else {
                for (List childElements : extensionElement.getChildElements().values()) {
                    for (ExtensionElement childElement : childElements) {
                        BpmnXMLUtil.writeExtensionElement(childElement, namespaceMap, xtw);
                    }
                }
            }
            for (String prefix : localNamespaceMap.keySet()) {
                namespaceMap.remove(prefix);
            }
            xtw.writeEndElement();
        }
    }

    public static List<String> parseDelimitedList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            StringCharacterIterator iterator = new StringCharacterIterator(s);
            char c = iterator.first();
            StringBuilder strb = new StringBuilder();
            boolean insideExpression = false;
            while (c != '\uffff') {
                if (c == '{' || c == '$') {
                    insideExpression = true;
                } else if (c == '}') {
                    insideExpression = false;
                } else if (c == ',' && !insideExpression) {
                    result.add(strb.toString().trim());
                    strb.delete(0, strb.length());
                }
                if (c != ',' || insideExpression) {
                    strb.append(c);
                }
                c = iterator.next();
            }
            if (strb.length() > 0) {
                result.add(strb.toString().trim());
            }
        }
        return result;
    }

    public static String convertToDelimitedString(List<String> stringList) {
        StringBuilder resultString = new StringBuilder();
        if (stringList != null) {
            for (String result : stringList) {
                if (resultString.length() > 0) {
                    resultString.append(",");
                }
                resultString.append(result);
            }
        }
        return resultString.toString();
    }

    public static void addCustomAttributes(XMLStreamReader xtr, BaseElement element, List<ExtensionAttribute> ... blackLists) {
        for (int i = 0; i < xtr.getAttributeCount(); ++i) {
            ExtensionAttribute extensionAttribute = new ExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            if (BpmnXMLUtil.isBlacklisted(extensionAttribute, blackLists)) continue;
            element.addAttribute(extensionAttribute);
        }
    }

    public static void writeCustomAttributes(Collection<List<ExtensionAttribute>> attributes, XMLStreamWriter xtw, List<ExtensionAttribute> ... blackLists) throws XMLStreamException {
        BpmnXMLUtil.writeCustomAttributes(attributes, xtw, new LinkedHashMap<String, String>(), blackLists);
    }

    public static void writeCustomAttributes(Collection<List<ExtensionAttribute>> attributes, XMLStreamWriter xtw, Map<String, String> namespaceMap, List<ExtensionAttribute> ... blackLists) throws XMLStreamException {
        for (List<ExtensionAttribute> attributeList : attributes) {
            if (attributeList == null || attributeList.isEmpty()) continue;
            for (ExtensionAttribute attribute : attributeList) {
                if (BpmnXMLUtil.isBlacklisted(attribute, blackLists)) continue;
                if (attribute.getNamespacePrefix() == null) {
                    if (attribute.getNamespace() == null) {
                        xtw.writeAttribute(attribute.getName(), attribute.getValue());
                        continue;
                    }
                    xtw.writeAttribute(attribute.getNamespace(), attribute.getName(), attribute.getValue());
                    continue;
                }
                if (!namespaceMap.containsKey(attribute.getNamespacePrefix())) {
                    namespaceMap.put(attribute.getNamespacePrefix(), attribute.getNamespace());
                    xtw.writeNamespace(attribute.getNamespacePrefix(), attribute.getNamespace());
                }
                xtw.writeAttribute(attribute.getNamespacePrefix(), attribute.getNamespace(), attribute.getName(), attribute.getValue());
            }
        }
    }

    public static boolean isBlacklisted(ExtensionAttribute attribute, List<ExtensionAttribute> ... blackLists) {
        if (blackLists != null) {
            for (List<ExtensionAttribute> blackList : blackLists) {
                for (ExtensionAttribute blackAttribute : blackList) {
                    if (!blackAttribute.getName().equals(attribute.getName())) continue;
                    if (blackAttribute.getNamespace() != null && attribute.getNamespace() != null && blackAttribute.getNamespace().equals(attribute.getNamespace())) {
                        return true;
                    }
                    if (blackAttribute.getNamespace() != null || attribute.getNamespace() != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void writeIncomingAndOutgoingFlowElement(FlowNode flowNode, XMLStreamWriter xtw) throws Exception {
        if (!flowNode.getIncomingFlows().isEmpty()) {
            for (SequenceFlow incomingSequence : flowNode.getIncomingFlows()) {
                BpmnXMLUtil.writeIncomingElementChild(xtw, incomingSequence);
            }
        }
        if (!flowNode.getOutgoingFlows().isEmpty()) {
            for (SequenceFlow outgoingSequence : flowNode.getOutgoingFlows()) {
                BpmnXMLUtil.writeOutgoingElementChild(xtw, outgoingSequence);
            }
        }
    }

    public static void writeIncomingElementChild(XMLStreamWriter xtw, SequenceFlow incomingSequence) throws Exception {
        xtw.writeStartElement("bpmn2", "incoming", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeCharacters(incomingSequence.getId());
        xtw.writeEndElement();
    }

    public static void writeOutgoingElementChild(XMLStreamWriter xtw, SequenceFlow outgoingSequence) throws Exception {
        xtw.writeStartElement("bpmn2", "outgoing", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeCharacters(outgoingSequence.getId());
        xtw.writeEndElement();
    }

    public static XMLInputFactory createSafeXmlInputFactory() {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        return xif;
    }

    static {
        BpmnXMLUtil.addGenericParser(new ActivitiEventListenerParser());
        BpmnXMLUtil.addGenericParser(new CancelEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new CompensateEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new ConditionExpressionParser());
        BpmnXMLUtil.addGenericParser(new DataInputAssociationParser());
        BpmnXMLUtil.addGenericParser(new DataOutputAssociationParser());
        BpmnXMLUtil.addGenericParser(new DataStateParser());
        BpmnXMLUtil.addGenericParser(new DocumentationParser());
        BpmnXMLUtil.addGenericParser(new ErrorEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new ExecutionListenerParser());
        BpmnXMLUtil.addGenericParser(new FieldExtensionParser());
        BpmnXMLUtil.addGenericParser(new FormPropertyParser());
        BpmnXMLUtil.addGenericParser(new IOSpecificationParser());
        BpmnXMLUtil.addGenericParser(new MessageEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new MultiInstanceParser());
        BpmnXMLUtil.addGenericParser(new SignalEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new TaskListenerParser());
        BpmnXMLUtil.addGenericParser(new TerminateEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new TimerEventDefinitionParser());
        BpmnXMLUtil.addGenericParser(new TimeDateParser());
        BpmnXMLUtil.addGenericParser(new TimeCycleParser());
        BpmnXMLUtil.addGenericParser(new TimeDurationParser());
        BpmnXMLUtil.addGenericParser(new FlowNodeRefParser());
        BpmnXMLUtil.addGenericParser(new ActivitiFailedjobRetryParser());
        BpmnXMLUtil.addGenericParser(new ActivitiMapExceptionParser());
    }
}

