/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.child.TextAnnotationTextParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.TextAnnotation;
import org.apache.commons.lang3.StringUtils;

public class TextAnnotationXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public TextAnnotationXMLConverter() {
        TextAnnotationTextParser annotationTextParser = new TextAnnotationTextParser();
        this.childParserMap.put(annotationTextParser.getElementName(), annotationTextParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return TextAnnotation.class;
    }

    @Override
    protected String getXMLElementName() {
        return "textAnnotation";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        TextAnnotation textAnnotation = new TextAnnotation();
        BpmnXMLUtil.addXMLLocation((BaseElement)textAnnotation, xtr);
        textAnnotation.setTextFormat(xtr.getAttributeValue(null, "textFormat"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)textAnnotation, this.childParserMap, model, xtr);
        return textAnnotation;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        TextAnnotation textAnnotation = (TextAnnotation)element;
        this.writeDefaultAttribute("textFormat", textAnnotation.getTextFormat(), xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        TextAnnotation textAnnotation = (TextAnnotation)element;
        if (StringUtils.isNotEmpty((CharSequence)textAnnotation.getText())) {
            xtw.writeStartElement("bpmn2", "text", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            xtw.writeCharacters(textAnnotation.getText());
            xtw.writeEndElement();
        }
    }
}

