/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.model.LinkEventDefinition;
import org.apache.commons.lang3.StringUtils;

public class LinkEventDefinitionXMLConverter {
    public static final String ELEMENT_EVENT_LINK_DEFINITION = "linkEventDefinition";
    public static final String ATTRIBUTE_LINK_SOURCE = "source";
    public static final String ATTRIBUTE_LINK_TARGET = "target";

    public void writeLinkDefinition(LinkEventDefinition eventDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("bpmn2", ELEMENT_EVENT_LINK_DEFINITION, "http://www.omg.org/spec/BPMN/20100524/MODEL");
        this.writeAttribute(xtw, "id", eventDefinition.getId());
        this.writeAttribute(xtw, "name", eventDefinition.getName());
        this.writeElement(xtw, ATTRIBUTE_LINK_TARGET, eventDefinition.getTarget());
        if (eventDefinition.getSources() != null) {
            for (String source : eventDefinition.getSources()) {
                this.writeElement(xtw, ATTRIBUTE_LINK_SOURCE, source);
            }
        }
        xtw.writeEndElement();
    }

    private void writeAttribute(XMLStreamWriter xtw, String attributeName, String attributeValue) throws XMLStreamException {
        if (attributeValue != null) {
            xtw.writeAttribute(attributeName, attributeValue);
        }
    }

    private void writeElement(XMLStreamWriter xtw, String elementName, String elementValue) throws XMLStreamException {
        if (StringUtils.isNotEmpty((CharSequence)elementValue)) {
            xtw.writeStartElement("bpmn2", elementName, "http://www.omg.org/spec/BPMN/20100524/MODEL");
            xtw.writeCharacters(elementValue);
            xtw.writeEndElement();
        }
    }
}

