/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ThrowEvent;
import org.apache.commons.collections4.CollectionUtils;

public abstract class FlowNode
extends FlowElement {
    protected boolean asynchronous;
    protected boolean notExclusive;
    protected List<SequenceFlow> incomingFlows = new ArrayList<SequenceFlow>();
    protected List<SequenceFlow> outgoingFlows = new ArrayList<SequenceFlow>();
    @JsonIgnore
    protected Object behavior;

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isExclusive() {
        return !this.notExclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.notExclusive = !exclusive;
    }

    public boolean isNotExclusive() {
        return this.notExclusive;
    }

    public void setNotExclusive(boolean notExclusive) {
        this.notExclusive = notExclusive;
    }

    public Object getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Object behavior) {
        this.behavior = behavior;
    }

    public List<SequenceFlow> getIncomingFlows() {
        return this.incomingFlows;
    }

    public void setIncomingFlows(List<SequenceFlow> incomingFlows) {
        this.incomingFlows = incomingFlows;
    }

    public List<SequenceFlow> getOutgoingFlows() {
        return this.outgoingFlows;
    }

    public void setOutgoingFlows(List<SequenceFlow> outgoingFlows) {
        this.outgoingFlows = outgoingFlows;
    }

    public void setValues(FlowNode otherNode) {
        super.setValues(otherNode);
        this.setAsynchronous(otherNode.isAsynchronous());
        this.setNotExclusive(otherNode.isNotExclusive());
    }

    public boolean hasIncomingFlows() {
        return CollectionUtils.isNotEmpty(this.incomingFlows);
    }

    public boolean hasOutgoingFlows() {
        return CollectionUtils.isNotEmpty(this.outgoingFlows);
    }

    public boolean isLinkCatchEvent() {
        FlowNode flowNode = this;
        if (flowNode instanceof IntermediateCatchEvent) {
            IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)flowNode;
            return intermediateCatchEvent.isLinkEvent();
        }
        return false;
    }

    public boolean isLinkThrowEvent() {
        FlowNode flowNode = this;
        if (flowNode instanceof ThrowEvent) {
            ThrowEvent throwEvent = (ThrowEvent)flowNode;
            return throwEvent.isLinkEvent();
        }
        return false;
    }

    public boolean isInitialFlowNode() {
        return CollectionUtils.isEmpty(this.getIncomingFlows()) && this.getSubProcess() == null && !this.isLinkCatchEvent();
    }
}

