/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.common.util;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;

public class DateFormatterProvider {
    private String dateFormatPattern;
    private ZoneId zoneId = ZoneOffset.UTC;

    public DateFormatterProvider(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public Date parse(String value) throws DateTimeException {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(this.getDateFormatPattern()).toFormatter().withZone(this.getZoneId());
        try {
            ZonedDateTime zonedDateTime = dateTimeFormatter.parse((CharSequence)value, ZonedDateTime::from);
            return Date.from(zonedDateTime.toInstant());
        }
        catch (DateTimeException e) {
            LocalDate localDate = dateTimeFormatter.parse((CharSequence)String.valueOf(value), LocalDate::from);
            return Date.from(localDate.atStartOfDay().atZone(this.getZoneId()).toInstant());
        }
    }

    public Date toDate(Object value) {
        if (value instanceof String) {
            return this.parse((String)value);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof LocalDate) {
            return Date.from(((LocalDate)value).atStartOfDay(this.getZoneId()).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(this.getZoneId()).toInstant());
        }
        if (value instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)value).toInstant());
        }
        throw new DateTimeException(MessageFormat.format("Error while parsing date. Type: {0}, value: {1}", value.getClass().getName(), value));
    }
}

