/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;
    protected String deleteReason;
    protected boolean cancel;

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade) {
        this(taskId, deleteReason, cascade, false);
    }

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade, boolean cancel) {
        this.taskId = taskId;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
        this.cancel = cancel;
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade) {
        this(taskIds, deleteReason, cascade, false);
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade, boolean cancel) {
        this.taskIds = taskIds;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
        this.cancel = cancel;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(commandContext, this.taskId);
        } else if (this.taskIds != null) {
            for (String taskId : this.taskIds) {
                this.deleteTask(commandContext, taskId);
            }
        } else {
            throw new ActivitiIllegalArgumentException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(CommandContext commandContext, String taskId) {
        commandContext.getTaskEntityManager().deleteTask(taskId, this.deleteReason, this.cascade, this.cancel);
    }
}

