/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cmd.ExecuteAsyncJobCmd;
import org.activiti.engine.impl.cmd.HandleFailedJobCmd;
import org.activiti.engine.impl.cmd.LockExclusiveJobCmd;
import org.activiti.engine.impl.cmd.UnlockExclusiveJobCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected String jobId;
    protected Job job;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ExecuteAsyncRunnable(String jobId, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.jobId = jobId;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ExecuteAsyncRunnable(Job job, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.job = job;
        this.jobId = job.getId();
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void run() {
        if (this.job == null) {
            this.job = this.processEngineConfiguration.getCommandExecutor().execute(new Command<JobEntity>(){

                @Override
                public JobEntity execute(CommandContext commandContext) {
                    return (JobEntity)commandContext.getJobEntityManager().findById(ExecuteAsyncRunnable.this.jobId);
                }
            });
        }
        this.runInternal();
    }

    protected void runInternal() {
        boolean lockNotNeededOrSuccess = this.lockJobIfNeeded();
        if (lockNotNeededOrSuccess) {
            this.executeJob();
            this.unlockJobIfNeeded();
        }
    }

    protected void executeJob() {
        try {
            this.processEngineConfiguration.getCommandExecutor().execute(new ExecuteAsyncJobCmd(this.jobId));
        }
        catch (ActivitiOptimisticLockingException e) {
            this.handleFailedJob(e);
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable exception) {
            this.handleFailedJob(exception);
            String message = "Job " + this.jobId + " failed";
            log.error(message, exception);
        }
    }

    protected void unlockJobIfNeeded() {
        try {
            if (this.job.isExclusive()) {
                this.processEngineConfiguration.getCommandExecutor().execute(new UnlockExclusiveJobCmd(this.job));
            }
        }
        catch (ActivitiOptimisticLockingException optimisticLockingException) {
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable t) {
            log.error("Error while unlocking exclusive job " + this.job.getId(), t);
        }
    }

    protected boolean lockJobIfNeeded() {
        try {
            if (this.job.isExclusive()) {
                this.processEngineConfiguration.getCommandExecutor().execute(new LockExclusiveJobCmd(this.job));
            }
        }
        catch (Throwable lockException) {
            if (log.isDebugEnabled()) {
                log.debug("Could not lock exclusive job. Unlocking job so it can be acquired again. Catched exception: " + lockException.getMessage());
            }
            this.unacquireJob();
            return false;
        }
        return true;
    }

    protected void unacquireJob() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getJobManager().unacquire(this.job);
        } else {
            this.processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    commandContext.getJobManager().unacquire(ExecuteAsyncRunnable.this.job);
                    return null;
                }
            });
        }
    }

    protected void handleFailedJob(Throwable exception) {
        this.processEngineConfiguration.getCommandExecutor().execute(new HandleFailedJobCmd(this.jobId, this.processEngineConfiguration, exception));
    }
}

