/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.factory;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.parser.factory.MessageExecutionContext;
import org.activiti.engine.impl.delegate.MessagePayloadMappingProvider;
import org.activiti.engine.impl.delegate.ThrowMessage;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;

public class DefaultMessageExecutionContext
implements MessageExecutionContext {
    private final ExpressionManager expressionManager;
    private final MessagePayloadMappingProvider messagePayloadMappingProvider;
    private final MessageEventDefinition messageEventDefinition;

    public DefaultMessageExecutionContext(MessageEventDefinition messageEventDefinition, ExpressionManager expressionManager, MessagePayloadMappingProvider messagePayloadMappingProvider) {
        this.messageEventDefinition = messageEventDefinition;
        this.expressionManager = expressionManager;
        this.messagePayloadMappingProvider = messagePayloadMappingProvider;
    }

    @Override
    public String getMessageName(DelegateExecution execution) {
        return this.evaluateExpression(Optional.ofNullable(this.messageEventDefinition.getMessageRef()).orElseGet(() -> this.messageEventDefinition.getMessageExpression()), execution);
    }

    public Optional<String> getCorrelationKey(DelegateExecution execution) {
        return Optional.ofNullable(this.messageEventDefinition.getCorrelationKey()).map(correlationKey -> this.evaluateExpression(this.messageEventDefinition.getCorrelationKey(), execution));
    }

    public Optional<Map<String, Object>> getMessagePayload(DelegateExecution execution) {
        return this.messagePayloadMappingProvider.getMessagePayload(execution);
    }

    @Override
    public ThrowMessage createThrowMessage(DelegateExecution execution) {
        String name = this.getMessageName(execution);
        Optional<String> correlationKey = this.getCorrelationKey(execution);
        Optional<String> businessKey = Optional.ofNullable(execution.getProcessInstanceBusinessKey());
        Optional<Map<String, Object>> payload = this.getMessagePayload(execution);
        return ThrowMessage.builder().name(name).correlationKey(correlationKey).businessKey(businessKey).payload(payload).build();
    }

    @Override
    public MessageEventSubscriptionEntity createMessageEventSubscription(CommandContext commandContext, DelegateExecution execution) {
        String messageName = this.getMessageName(execution);
        Optional<String> correlationKey = this.getCorrelationKey(execution);
        correlationKey.ifPresent(key -> this.assertNoExistingDuplicateEventSubscriptions(messageName, (String)key, commandContext));
        MessageEventSubscriptionEntity messageEvent = commandContext.getEventSubscriptionEntityManager().insertMessageEvent(messageName, (ExecutionEntity)ExecutionEntity.class.cast(execution));
        correlationKey.ifPresent(messageEvent::setConfiguration);
        return messageEvent;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public MessagePayloadMappingProvider getMessagePayloadMappingProvider() {
        return this.messagePayloadMappingProvider;
    }

    protected String evaluateExpression(String expression, DelegateExecution execution) {
        return Optional.ofNullable(this.expressionManager.createExpression(expression)).map(it -> it.getValue(execution)).map(Object::toString).orElseThrow(() -> new ActivitiIllegalArgumentException("Expression '" + expression + "' is null"));
    }

    protected void assertNoExistingDuplicateEventSubscriptions(String messageName, String correlationKey, CommandContext commandContext) {
        List<EventSubscriptionEntity> existing = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByName("message", messageName, null);
        existing.stream().filter(subscription -> Objects.equals(subscription.getConfiguration(), correlationKey)).findFirst().ifPresent(subscription -> {
            throw new ActivitiIllegalArgumentException("Duplicate message subscription '" + subscription.getEventName() + "' with correlation key '" + subscription.getConfiguration() + "'");
        });
    }
}

