/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.cmd.AbstractCompleteTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
extends AbstractCompleteTaskCmd {
    private static final long serialVersionUID = 1L;
    private static final String ASSIGNEE_VARIABLE_NAME = "sys_task_assignee";
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> taskVariables;
    protected boolean localScope;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, boolean localScope) {
        this(taskId, variables);
        this.localScope = localScope;
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.variables != null) {
            if (this.localScope) {
                task.setVariablesLocal(this.variables);
            } else if (task.getExecutionId() != null) {
                task.setExecutionVariables(this.variables);
            } else {
                task.setVariables(this.variables);
            }
        }
        if (this.transientVariables != null) {
            if (this.localScope) {
                task.setTransientVariablesLocal(this.transientVariables);
            } else {
                task.setTransientVariables(this.transientVariables);
            }
        }
        HashMap<String, Object> taskLocalVariables = new HashMap<String, Object>(task.getVariablesLocal());
        taskLocalVariables.put(ASSIGNEE_VARIABLE_NAME, task.getAssignee());
        this.setTaskVariables(taskLocalVariables);
        this.executeTaskComplete(commandContext, task, this.variables, this.localScope);
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }

    public Map<String, Object> getTaskVariables() {
        return this.taskVariables;
    }

    private void setTaskVariables(Map<String, Object> taskVariables) {
        this.taskVariables = taskVariables;
    }
}

