/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.variable.JsonType;
import org.activiti.engine.impl.variable.ValueFields;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonType.class);
    private ObjectMapper objectMapper;
    private String javaClassFieldForJackson;

    public JsonTypeConverter(ObjectMapper objectMapper, String javaClassFieldForJackson) {
        this.objectMapper = objectMapper;
        this.javaClassFieldForJackson = javaClassFieldForJackson;
    }

    public Object convertToValue(JsonNode jsonValue, ValueFields valueFields) {
        Object convertedValue = jsonValue;
        if (jsonValue != null && StringUtils.isNotBlank((CharSequence)this.javaClassFieldForJackson)) {
            JsonNode classNode = jsonValue.get(this.javaClassFieldForJackson);
            try {
                if (classNode != null) {
                    String type = classNode.asText();
                    convertedValue = this.convertToType(jsonValue, type);
                } else if (valueFields.getTextValue2() != null && !jsonValue.getClass().getName().equals(valueFields.getTextValue2())) {
                    convertedValue = this.convertToType(jsonValue, valueFields.getTextValue2());
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Unable to obtain type for json variable object " + valueFields.getName(), (Throwable)e);
            }
        }
        return convertedValue;
    }

    private Object convertToType(JsonNode jsonValue, String type) throws ClassNotFoundException {
        return this.objectMapper.convertValue((Object)jsonValue, this.loadClass(type));
    }

    private Class<?> loadClass(String type) throws ClassNotFoundException {
        return Class.forName(type, false, this.getClass().getClassLoader());
    }
}

