/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class LocalDateTimeType
implements VariableType {
    @Override
    public String getTypeName() {
        return "localDateTime";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return LocalDateTime.class.isAssignableFrom(value.getClass());
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            return LocalDateTime.ofEpochSecond(longValue, 0, ZoneOffset.UTC);
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((LocalDateTime)value).toEpochSecond(ZoneOffset.UTC));
        } else {
            valueFields.setLongValue(null);
        }
    }
}

