/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.data.Data;
import org.activiti.engine.impl.bpmn.data.DataRef;

public class IOSpecification {
    protected List<Data> dataInputs = new ArrayList<Data>();
    protected List<Data> dataOutputs = new ArrayList<Data>();
    protected List<DataRef> dataInputRefs = new ArrayList<DataRef>();
    protected List<DataRef> dataOutputRefs = new ArrayList<DataRef>();

    public void initialize(DelegateExecution execution) {
        for (Data data : this.dataInputs) {
            execution.setVariable(data.getName(), data.getDefinition().createInstance());
        }
        for (Data data : this.dataOutputs) {
            execution.setVariable(data.getName(), data.getDefinition().createInstance());
        }
    }

    public List<Data> getDataInputs() {
        return Collections.unmodifiableList(this.dataInputs);
    }

    public List<Data> getDataOutputs() {
        return Collections.unmodifiableList(this.dataOutputs);
    }

    public void addInput(Data data) {
        this.dataInputs.add(data);
    }

    public void addOutput(Data data) {
        this.dataOutputs.add(data);
    }

    public void addInputRef(DataRef dataRef) {
        this.dataInputRefs.add(dataRef);
    }

    public void addOutputRef(DataRef dataRef) {
        this.dataOutputRefs.add(dataRef);
    }

    public String getFirstDataInputName() {
        return this.dataInputs.get(0).getName();
    }

    public String getFirstDataOutputName() {
        if (this.dataOutputs != null && !this.dataOutputs.isEmpty()) {
            return this.dataOutputs.get(0).getName();
        }
        return null;
    }
}

