/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueProcessOperation
extends AbstractOperation {
    private static Logger logger = LoggerFactory.getLogger(ContinueProcessOperation.class);
    protected boolean forceSynchronousOperation;
    protected boolean inCompensation;

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation, boolean inCompensation) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
        this.inCompensation = inCompensation;
    }

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution) {
        this(commandContext, execution, false, false);
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof FlowNode) {
            this.continueThroughFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.continueThroughSequenceFlow((SequenceFlow)currentFlowElement);
        } else {
            throw new ActivitiException("Programmatic error: no current flow element found or invalid type: " + String.valueOf(currentFlowElement) + ". Halting.");
        }
    }

    protected void executeProcessStartExecutionListeners() {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId());
        this.executeExecutionListeners((HasExecutionListeners)process, this.execution.getParent(), "start");
    }

    protected void continueThroughFlowNode(FlowNode flowNode) {
        if (flowNode.getIncomingFlows() != null && flowNode.getIncomingFlows().size() == 0 && flowNode.getSubProcess() == null) {
            this.executeProcessStartExecutionListeners();
        }
        if (SubProcess.class.isInstance(flowNode) && !this.isMultiInstance(flowNode).booleanValue()) {
            this.createChildExecutionForSubProcess((SubProcess)flowNode);
        }
        if (this.isMultiInstance(flowNode).booleanValue()) {
            this.executeMultiInstanceSynchronous(flowNode);
        } else if (this.forceSynchronousOperation || !flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected Boolean isMultiInstance(FlowNode flowNode) {
        return Optional.ofNullable(flowNode).filter(Activity.class::isInstance).map(Activity.class::cast).map(Activity::hasMultiInstanceLoopCharacteristics).orElse(false);
    }

    protected void createChildExecutionForSubProcess(SubProcess subProcess) {
        ExecutionEntity parentScopeExecution = this.findFirstParentScopeExecution(this.execution);
        ExecutionEntity subProcessExecution = this.commandContext.getExecutionEntityManager().createChildExecution(parentScopeExecution);
        subProcessExecution.setCurrentFlowElement((FlowElement)subProcess);
        subProcessExecution.setScope(true);
        this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(this.execution, null);
        this.execution = subProcessExecution;
    }

    protected void executeSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List boundaryEvents;
        this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty(flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty(boundaryEvents = ((Activity)flowNode).getBoundaryEvents())) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            this.executeActivityBehavior(activityBehavior, flowNode);
        } else {
            logger.debug("No activityBehavior on activity '{}' with execution {}", (Object)flowNode.getId(), (Object)this.execution.getId());
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(this.execution, true);
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        JobEntity job = this.commandContext.getJobManager().createAsyncJob(this.execution, flowNode.isExclusive());
        this.commandContext.getJobManager().scheduleAsyncJob(job);
    }

    protected void executeMultiInstanceSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List boundaryEvents;
        if (CollectionUtil.isNotEmpty(flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty(boundaryEvents = ((Activity)flowNode).getBoundaryEvents())) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) == null) {
            throw new ActivitiException("Expected an activity behavior in flow node " + flowNode.getId());
        }
        this.executeActivityBehavior(activityBehavior, flowNode);
    }

    protected void executeActivityBehavior(ActivityBehavior activityBehavior, FlowNode flowNode) {
        logger.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && !(activityBehavior instanceof MultiInstanceActivityBehavior)) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_STARTED, this.execution, (FlowElement)flowNode));
        }
        try {
            activityBehavior.execute(this.execution);
        }
        catch (RuntimeException e) {
            if (LogMDC.isMDCEnabled()) {
                LogMDC.putMDCExecution(this.execution);
            }
            throw e;
        }
    }

    protected void continueThroughSequenceFlow(SequenceFlow sequenceFlow) {
        if (CollectionUtil.isNotEmpty(sequenceFlow.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "start");
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "take");
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "end");
        }
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createSequenceFlowTakenEvent(this.execution, ActivitiEventType.SEQUENCEFLOW_TAKEN, sequenceFlow.getId(), sourceFlowElement != null ? sourceFlowElement.getId() : null, sourceFlowElement != null ? sourceFlowElement.getName() : null, sourceFlowElement != null ? sourceFlowElement.getClass().getName() : null, sourceFlowElement != null ? ((FlowNode)sourceFlowElement).getBehavior() : null, targetFlowElement != null ? targetFlowElement.getId() : null, targetFlowElement != null ? targetFlowElement.getName() : null, targetFlowElement != null ? targetFlowElement.getClass().getName() : null, targetFlowElement != null ? ((FlowNode)targetFlowElement).getBehavior() : null));
        }
        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        this.execution.setCurrentFlowElement(targetFlowElement);
        logger.debug("Sequence flow '{}' encountered. Continuing process by following it using execution {}", (Object)sequenceFlow.getId(), (Object)this.execution.getId());
        Context.getAgenda().planContinueProcessOperation(this.execution);
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = this.commandContext.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            logger.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)childExecutionEntity.getId());
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }
}

