/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleFailedJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(HandleFailedJobCmd.class);
    protected String jobId;
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public HandleFailedJobCmd(String jobId, ProcessEngineConfigurationImpl processEngineConfiguration, Throwable exception) {
        this.jobId = jobId;
        this.processEngineConfiguration = processEngineConfiguration;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        Job job = (Job)commandContext.getJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing job {}", (Object)job.getId());
        }
        this.executeInternal(commandContext, job);
        return null;
    }

    protected void executeInternal(CommandContext commandContext, Job job) {
        CommandConfig commandConfig = this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        Command<Object> cmd = failedJobCommandFactory.getCommand(job.getId(), this.exception);
        log.trace("Using FailedJobCommandFactory '" + String.valueOf(failedJobCommandFactory.getClass()) + "' and command of type '" + String.valueOf(cmd.getClass()) + "'");
        this.processEngineConfiguration.getCommandExecutor().execute(commandConfig, cmd);
        if (commandContext.getEventDispatcher().isEnabled()) {
            try {
                commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityExceptionEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, job, this.exception));
            }
            catch (Throwable ignore) {
                log.warn("Exception occurred while dispatching job failure event, ignoring.", ignore);
            }
        }
    }
}

