/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.activiti.engine.impl.scripting.JuelScriptEngine;

public class JuelScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = Collections.singletonList("juel");
    private static List<String> extensions = names;
    private static List<String> mimeTypes = Collections.unmodifiableList(new ArrayList(0));

    @Override
    public String getEngineName() {
        return "juel";
    }

    @Override
    public String getEngineVersion() {
        return "1.0";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "JSP 2.1 EL";
    }

    @Override
    public String getLanguageVersion() {
        return "2.1";
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... arguments) {
        throw new UnsupportedOperationException("Method getMethodCallSyntax is not supported");
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("out:print(\"");
        int length = toDisplay.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = toDisplay.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        if (statements.length != 0) {
            for (int i = 0; i < statements.length; ++i) {
                buf.append("${");
                buf.append(statements[i]);
                buf.append("} ");
            }
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JuelScriptEngine(this);
    }
}

