/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskParseHandler
extends AbstractActivityBpmnParseHandler<ServiceTask> {
    private static Logger logger = LoggerFactory.getLogger(ServiceTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ServiceTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ServiceTask serviceTask) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            this.createActivityBehaviorForServiceTaskType(bpmnParse, serviceTask);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(serviceTask.getImplementationType())) {
            this.createClassDelegateServiceTask(bpmnParse, serviceTask);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            this.createServiceTaskDelegateExpressionActivityBehavior(bpmnParse, serviceTask);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            this.createServiceTaskExpressionActivityBehavior(bpmnParse, serviceTask);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            this.createWebServiceActivityBehavior(bpmnParse, serviceTask);
        } else {
            this.createDefaultServiceTaskActivityBehavior(bpmnParse, serviceTask);
        }
    }

    protected void createActivityBehaviorForServiceTaskType(BpmnParse bpmnParse, ServiceTask serviceTask) {
        if (serviceTask.getType().equalsIgnoreCase("mail")) {
            this.createMailActivityBehavior(bpmnParse, serviceTask);
        } else if (serviceTask.getType().equalsIgnoreCase("mule")) {
            this.createMuleActivityBehavior(bpmnParse, serviceTask);
        } else if (serviceTask.getType().equalsIgnoreCase("camel")) {
            this.createCamelActivityBehavior(bpmnParse, serviceTask);
        } else if (serviceTask.getType().equalsIgnoreCase("shell")) {
            this.createShellActivityBehavior(bpmnParse, serviceTask);
        } else {
            this.createActivityBehaviorForCustomServiceTaskType(bpmnParse, serviceTask);
        }
    }

    protected void createMailActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(serviceTask));
    }

    protected void createMuleActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(serviceTask));
    }

    protected void createCamelActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(serviceTask));
    }

    protected void createShellActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createShellActivityBehavior(serviceTask));
    }

    protected void createActivityBehaviorForCustomServiceTaskType(BpmnParse bpmnParse, ServiceTask serviceTask) {
        logger.warn("Invalid service task type: '" + serviceTask.getType() + "'  for service task " + serviceTask.getId());
    }

    protected void createClassDelegateServiceTask(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createClassDelegateServiceTask(serviceTask));
    }

    protected void createServiceTaskDelegateExpressionActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior(serviceTask));
    }

    protected void createServiceTaskExpressionActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior(serviceTask));
    }

    protected void createWebServiceActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(serviceTask));
    }

    protected void createDefaultServiceTaskActivityBehavior(BpmnParse bpmnParse, ServiceTask serviceTask) {
        serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createDefaultServiceTaskBehavior(serviceTask));
    }
}

