/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static Map<String, Object> singletonMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static Map<String, Object> map(Object ... objects) {
        return CollectionUtil.mapOfClass(Object.class, objects);
    }

    public static <T> Map<String, T> mapOfClass(Class<T> clazz, Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new ActivitiIllegalArgumentException("The input should always be even since we expect a list of key-value pairs!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            int keyIndex = i;
            int valueIndex = i + 1;
            Object key = objects[keyIndex];
            Object value = objects[valueIndex];
            if (!String.class.isInstance(key)) {
                throw new ActivitiIllegalArgumentException("key at index " + keyIndex + " should be a String but is a " + String.valueOf(key.getClass()));
            }
            if (value != null && !clazz.isInstance(value)) {
                throw new ActivitiIllegalArgumentException("value at index " + valueIndex + " should be a " + String.valueOf(clazz) + " but is a " + String.valueOf(value.getClass()));
            }
            map.put((String)key, value);
        }
        return map;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }
}

