/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.activiti.engine.impl.cmd.DeleteDeploymentCmd;
import org.activiti.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.repository.DeploymentBuilderImpl;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployCmd.class);
    private static final long serialVersionUID = 1L;
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        return this.executeDeploy(commandContext);
    }

    protected Deployment executeDeploy(CommandContext commandContext) {
        DeploymentEntity newDeployment = this.setUpNewDeploymentFromContext(commandContext);
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList<DeploymentEntity> existingDeployments = new ArrayList<DeploymentEntity>();
            if (newDeployment.getTenantId() == null || "".equals(newDeployment.getTenantId())) {
                DeploymentEntity latestDeployment = this.getLatestDeployment(commandContext, newDeployment);
                if (latestDeployment != null) {
                    existingDeployments.add(latestDeployment);
                }
            } else {
                List deploymentList = ((DeploymentQuery)commandContext.getProcessEngineConfiguration().getRepositoryService().createDeploymentQuery().deploymentName(newDeployment.getName()).deploymentTenantId(newDeployment.getTenantId()).orderByDeploymentId().desc()).list();
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            if (!existingDeployments.isEmpty()) {
                DeploymentEntity existingDeployment = (DeploymentEntity)existingDeployments.get(0);
                if (existingDeployment.getVersion() > newDeployment.getVersion()) {
                    newDeployment.setVersion(existingDeployment.getVersion());
                }
                if (this.deploymentsDiffer(newDeployment, existingDeployment)) {
                    this.applyUpgradeLogic(newDeployment, existingDeployment);
                } else {
                    LOGGER.info("An existing deployment of version {} matching the current one was found, no need to deploy again.", (Object)existingDeployment.getVersion());
                    return existingDeployment;
                }
            }
        }
        DeployCmd.persistDeploymentInDatabase(commandContext, newDeployment);
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isBpmn20XsdValidationEnabled", this.deploymentBuilder.isBpmn20XsdValidationEnabled());
        deploymentSettings.put("isProcessValidationEnabled", this.deploymentBuilder.isProcessValidationEnabled());
        LOGGER.info("Launching new deployment with version: " + newDeployment.getVersion());
        commandContext.getProcessEngineConfiguration().getDeploymentManager().deploy(newDeployment, deploymentSettings);
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            this.scheduleProcessDefinitionActivation(commandContext, newDeployment);
        }
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, newDeployment));
        }
        return newDeployment;
    }

    private static void persistDeploymentInDatabase(CommandContext commandContext, DeploymentEntity newDeployment) {
        commandContext.getDeploymentEntityManager().insert(newDeployment);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, newDeployment));
        }
    }

    private DeploymentEntity getLatestDeployment(CommandContext commandContext, DeploymentEntity newDeployment) {
        DeploymentEntity latestDeployment = commandContext.getDeploymentEntityManager().findLatestDeploymentByName(newDeployment.getName());
        if (latestDeployment != null) {
            latestDeployment = this.checkForRollback(commandContext, latestDeployment);
        }
        return latestDeployment;
    }

    private DeploymentEntity checkForRollback(CommandContext commandContext, DeploymentEntity latestDeployment) {
        if (commandContext.getProcessEngineConfiguration().isRollbackDeployment() && latestDeployment.getVersion() > this.deploymentBuilder.getEnforcedAppVersion()) {
            LOGGER.info("Rollback detected: Previous rolled back deployment will be deleted");
            DeleteDeploymentCmd deleteDeploymentCmd = new DeleteDeploymentCmd(latestDeployment.getId(), false);
            deleteDeploymentCmd.execute(commandContext);
            return this.getDeploymentEntityForCurrentEnforcedAppVersion(commandContext);
        }
        return latestDeployment;
    }

    private DeploymentEntity getDeploymentEntityForCurrentEnforcedAppVersion(CommandContext commandContext) {
        return commandContext.getDeploymentEntityManager().findDeploymentByVersion(this.deploymentBuilder.getEnforcedAppVersion());
    }

    private DeploymentEntity setUpNewDeploymentFromContext(CommandContext commandContext) {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        this.setProjectReleaseVersion(deployment);
        deployment.setVersion(1);
        deployment.setNew(true);
        return deployment;
    }

    private void setProjectReleaseVersion(DeploymentEntity deployment) {
        if (this.deploymentBuilder.hasProjectManifestSet()) {
            deployment.setProjectReleaseVersion(this.deploymentBuilder.getProjectManifest().getVersion());
        }
    }

    private void applyUpgradeLogic(DeploymentEntity deployment, DeploymentEntity existingDeployment) {
        if (this.deploymentBuilder.hasEnforcedAppVersion()) {
            deployment.setVersion(this.deploymentBuilder.getEnforcedAppVersion());
        } else if (this.deploymentBuilder.hasProjectManifestSet()) {
            deployment.setVersion(existingDeployment.getVersion() + 1);
        }
    }

    protected boolean deploymentsDiffer(DeploymentEntity deployment, DeploymentEntity saved) {
        if (this.deploymentBuilder.hasEnforcedAppVersion()) {
            return this.deploymentsDifferWhenEnforcedAppVersionIsSet(saved);
        }
        if (this.deploymentBuilder.hasProjectManifestSet()) {
            return this.deploymentsDifferWhenProjectManifestIsSet(deployment, saved);
        }
        return this.deploymentsDifferDefault(deployment, saved);
    }

    private boolean deploymentsDifferWhenEnforcedAppVersionIsSet(DeploymentEntity saved) {
        return !this.deploymentBuilder.getEnforcedAppVersion().equals(saved.getVersion());
    }

    private boolean deploymentsDifferWhenProjectManifestIsSet(DeploymentEntity deployment, DeploymentEntity saved) {
        return !deployment.getProjectReleaseVersion().equals(saved.getProjectReleaseVersion());
    }

    private boolean deploymentsDifferDefault(DeploymentEntity deployment, DeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            ResourceEntity resource;
            byte[] bytes;
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = resources.get(resourceName)).getBytes(), savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
            SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null, deployment.getTenantId());
            suspendProcessDefinitionCmd.execute(commandContext);
            ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate(), deployment.getTenantId());
            activateProcessDefinitionCmd.execute(commandContext);
        }
    }
}

