/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Optional;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.activiti.engine.repository.ProcessDefinition;

public class GetProcessDefinitionInfoCmd
implements Command<ObjectNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected ProcessDefinition processDefinition;

    public GetProcessDefinitionInfoCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public GetProcessDefinitionInfoCmd(ProcessDefinition processDefinition) {
        this(processDefinition.getId());
        this.processDefinition = processDefinition;
    }

    @Override
    public ObjectNode execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("process definition id is null");
        }
        DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinition = this.resolveProcessDefinition(deploymentManager);
        return this.executeInternal(deploymentManager, commandContext, processDefinition);
    }

    protected ProcessDefinition resolveProcessDefinition(DeploymentManager deploymentManager) {
        return Optional.ofNullable(this.processDefinition).orElseGet(() -> deploymentManager.findDeployedProcessDefinitionById(this.processDefinitionId));
    }

    protected ObjectNode executeInternal(DeploymentManager deploymentManager, CommandContext commandContext, ProcessDefinition processDefinition) {
        ObjectNode resultNode = null;
        ProcessDefinitionInfoCacheObject definitionInfoCacheObject = deploymentManager.getProcessDefinitionInfoCache().get(this.processDefinitionId);
        if (definitionInfoCacheObject != null) {
            resultNode = definitionInfoCacheObject.getInfoNode();
        }
        return resultNode;
    }
}

