/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskActivityBehavior.class);
    protected String scriptTaskId;
    protected String script;
    protected String language;
    protected String resultVariable;
    protected boolean storeScriptVariables = false;

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable) {
        this.script = script;
        this.language = language;
        this.resultVariable = resultVariable;
    }

    public ScriptTaskActivityBehavior(String scriptTaskId, String script, String language, String resultVariable, boolean storeScriptVariables) {
        this(script, language, resultVariable);
        this.scriptTaskId = scriptTaskId;
        this.storeScriptVariables = storeScriptVariables;
    }

    @Override
    public void execute(DelegateExecution execution) {
        String overrideScript;
        ObjectNode taskElementProperties;
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.scriptTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("scriptTaskScript") && StringUtils.isNotEmpty((CharSequence)(overrideScript = taskElementProperties.get("scriptTaskScript").asText())) && !overrideScript.equals(this.script)) {
            this.script = overrideScript;
        }
        boolean noErrors = true;
        try {
            Object result = scriptingEngines.evaluate(this.script, this.language, execution, this.storeScriptVariables);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ActivitiException e) {
            LOGGER.warn("Exception while executing " + execution.getCurrentFlowElement().getId() + " : " + e.getMessage());
            noErrors = false;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)rootCause, execution);
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

