/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class ClaimTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.userId != null) {
            task.setClaimTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new ActivitiTaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
            } else {
                commandContext.getTaskEntityManager().changeTaskAssignee(task, this.userId);
            }
        } else {
            task.setClaimTime(null);
            commandContext.getTaskEntityManager().changeTaskAssignee(task, null);
        }
        commandContext.getHistoryManager().recordTaskClaim(task);
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot claim a suspended task";
    }
}

