/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor.multitenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireAsyncJobsDueRunnable;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireTimerJobsRunnable;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareExecuteAsyncRunnable;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareResetExpiredJobsRunnable;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedExecutorServiceAsyncExecutor
extends DefaultAsyncJobExecutor
implements TenantAwareAsyncExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SharedExecutorServiceAsyncExecutor.class);
    protected TenantInfoHolder tenantInfoHolder;
    protected Map<String, Thread> timerJobAcquisitionThreads = new HashMap<String, Thread>();
    protected Map<String, TenantAwareAcquireTimerJobsRunnable> timerJobAcquisitionRunnables = new HashMap<String, TenantAwareAcquireTimerJobsRunnable>();
    protected Map<String, Thread> asyncJobAcquisitionThreads = new HashMap<String, Thread>();
    protected Map<String, TenantAwareAcquireAsyncJobsDueRunnable> asyncJobAcquisitionRunnables = new HashMap<String, TenantAwareAcquireAsyncJobsDueRunnable>();
    protected Map<String, Thread> resetExpiredJobsThreads = new HashMap<String, Thread>();
    protected Map<String, TenantAwareResetExpiredJobsRunnable> resetExpiredJobsRunnables = new HashMap<String, TenantAwareResetExpiredJobsRunnable>();

    public SharedExecutorServiceAsyncExecutor(TenantInfoHolder tenantInfoHolder) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.setExecuteAsyncRunnableFactory(new ExecuteAsyncRunnableFactory(){

            @Override
            public Runnable createExecuteAsyncRunnable(Job job, ProcessEngineConfigurationImpl processEngineConfiguration) {
                return new TenantAwareExecuteAsyncRunnable(job, processEngineConfiguration, SharedExecutorServiceAsyncExecutor.this.tenantInfoHolder, SharedExecutorServiceAsyncExecutor.this.tenantInfoHolder.getCurrentTenantId());
            }
        });
    }

    @Override
    public Set<String> getTenantIds() {
        return this.timerJobAcquisitionRunnables.keySet();
    }

    @Override
    public void addTenantAsyncExecutor(String tenantId, boolean startExecutor) {
        TenantAwareAcquireTimerJobsRunnable timerRunnable = new TenantAwareAcquireTimerJobsRunnable(this, this.tenantInfoHolder, tenantId);
        this.timerJobAcquisitionRunnables.put(tenantId, timerRunnable);
        this.timerJobAcquisitionThreads.put(tenantId, new Thread(timerRunnable));
        TenantAwareAcquireAsyncJobsDueRunnable asyncJobsRunnable = new TenantAwareAcquireAsyncJobsDueRunnable(this, this.tenantInfoHolder, tenantId);
        this.asyncJobAcquisitionRunnables.put(tenantId, asyncJobsRunnable);
        this.asyncJobAcquisitionThreads.put(tenantId, new Thread(asyncJobsRunnable));
        TenantAwareResetExpiredJobsRunnable resetExpiredJobsRunnable = new TenantAwareResetExpiredJobsRunnable(this, this.tenantInfoHolder, tenantId);
        this.resetExpiredJobsRunnables.put(tenantId, resetExpiredJobsRunnable);
        this.resetExpiredJobsThreads.put(tenantId, new Thread(resetExpiredJobsRunnable));
        if (startExecutor) {
            this.startThreadsForTenant(tenantId);
        }
    }

    private void startThreadsForTenant(String tenantId) {
        this.startTimerJobAcquisitionForTenant(tenantId);
        this.startAsyncJobAcquisitionForTenant(tenantId);
        this.startResetExpiredJobsForTenant(tenantId);
    }

    @Override
    public void removeTenantAsyncExecutor(String tenantId) {
        this.stopThreadsForTenant(tenantId);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.initAsyncJobExecutionThreadPool();
        for (String tenantId : this.timerJobAcquisitionRunnables.keySet()) {
            this.startThreadsForTenant(tenantId);
        }
    }

    protected void startTimerJobAcquisitionForTenant(String tenantId) {
        this.timerJobAcquisitionThreads.get(tenantId).start();
    }

    protected void startAsyncJobAcquisitionForTenant(String tenantId) {
        this.asyncJobAcquisitionThreads.get(tenantId).start();
    }

    protected void startResetExpiredJobsForTenant(String tenantId) {
        this.resetExpiredJobsThreads.get(tenantId).start();
    }

    @Override
    protected void stopJobAcquisitionThread() {
        for (String tenantId : this.timerJobAcquisitionRunnables.keySet()) {
            this.stopThreadsForTenant(tenantId);
        }
    }

    protected void stopThreadsForTenant(String tenantId) {
        this.timerJobAcquisitionRunnables.get(tenantId).stop();
        this.asyncJobAcquisitionRunnables.get(tenantId).stop();
        this.resetExpiredJobsRunnables.get(tenantId).stop();
        try {
            this.timerJobAcquisitionThreads.get(tenantId).join();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
        }
        try {
            this.asyncJobAcquisitionThreads.get(tenantId).join();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
        }
        try {
            this.resetExpiredJobsThreads.get(tenantId).join();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for the reset expired jobs thread to terminate", (Throwable)e);
        }
    }
}

