/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper.task;

import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.helper.task.TaskComparatorImpl;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.TaskInfo;

public class TaskUpdater {
    private final CommandContext commandContext;
    private final boolean broadcastEvents;

    public TaskUpdater(CommandContext commandContext) {
        this(commandContext, true);
    }

    public TaskUpdater(CommandContext commandContext, boolean broadcastEvents) {
        this.commandContext = commandContext;
        this.broadcastEvents = broadcastEvents;
    }

    public void updateTask(TaskInfo originalTask, TaskInfo task) {
        TaskComparatorImpl taskComparator = new TaskComparatorImpl();
        taskComparator.setOriginalTask(originalTask);
        taskComparator.setUpdatedTask(task);
        this.recordTaskUpdated(taskComparator);
        TaskEntity taskEntity = (TaskEntity)task;
        if (taskComparator.hasTaskOwnerChanged()) {
            if (task.getProcessInstanceId() != null) {
                this.commandContext.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), task.getOwner(), "participant");
            }
            this.commandContext.getHistoryManager().recordTaskOwnerChange(task.getId(), task.getOwner());
        }
        if (taskComparator.hasTaskAssigneeChanged()) {
            if (task.getProcessInstanceId() != null) {
                this.commandContext.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), task.getAssignee(), "participant");
            }
            this.commandContext.getHistoryManager().recordTaskAssigneeChange(task.getId(), task.getAssignee());
            if (this.broadcastEvents) {
                this.commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
            }
            this.commandContext.getHistoryManager().recordTaskAssignment(taskEntity);
            if (this.broadcastEvents && this.commandContext.getEventDispatcher().isEnabled()) {
                this.commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_ASSIGNED, task));
            }
        }
    }

    private void recordTaskUpdated(TaskComparatorImpl taskComparator) {
        if (this.commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            TaskInfo updatedTask = taskComparator.getUpdatedTask();
            if (taskComparator.hasTaskNameChanged()) {
                this.commandContext.getHistoryManager().recordTaskNameChange(updatedTask.getId(), updatedTask.getName());
            }
            if (taskComparator.hasTaskDescriptionChanged()) {
                this.commandContext.getHistoryManager().recordTaskDescriptionChange(updatedTask.getId(), updatedTask.getDescription());
            }
            if (taskComparator.hasTaskDueDateChanged()) {
                this.commandContext.getHistoryManager().recordTaskDueDateChange(updatedTask.getId(), updatedTask.getDueDate());
            }
            if (taskComparator.hasTaskPriorityChanged()) {
                this.commandContext.getHistoryManager().recordTaskPriorityChange(updatedTask.getId(), updatedTask.getPriority());
            }
            if (taskComparator.hasTaskCategoryChanged()) {
                this.commandContext.getHistoryManager().recordTaskCategoryChange(updatedTask.getId(), updatedTask.getCategory());
            }
            if (taskComparator.hasTaskFormKeyChanged()) {
                this.commandContext.getHistoryManager().recordTaskFormKeyChange(updatedTask.getId(), updatedTask.getFormKey());
            }
            if (taskComparator.hasTaskParentIdChanged()) {
                this.commandContext.getHistoryManager().recordTaskParentTaskIdChange(updatedTask.getId(), updatedTask.getParentTaskId());
            }
            if (taskComparator.hasTaskDefinitionKeyChanged()) {
                this.commandContext.getHistoryManager().recordTaskDefinitionKeyChange(updatedTask.getId(), updatedTask.getTaskDefinitionKey());
            }
        }
    }
}

