/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.DataObjectImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.runtime.DataObject;
import org.activiti.engine.runtime.Execution;

public class GetDataObjectsCmd
implements Command<Map<String, DataObject>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> dataObjectNames;
    protected boolean isLocal;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetDataObjectsCmd(String executionId, Collection<String> dataObjectNames, boolean isLocal) {
        this.executionId = executionId;
        this.dataObjectNames = dataObjectNames;
        this.isLocal = isLocal;
    }

    public GetDataObjectsCmd(String executionId, Collection<String> dataObjectNames, boolean isLocal, String locale, boolean withLocalizationFallback) {
        this.executionId = executionId;
        this.dataObjectNames = dataObjectNames;
        this.isLocal = isLocal;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public Map<String, DataObject> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        Map<String, VariableInstance> variables = this.getVariables(execution, commandContext);
        HashMap<String, DataObjectImpl> dataObjects = null;
        if (variables != null) {
            dataObjects = new HashMap<String, DataObjectImpl>(variables.size());
            for (Map.Entry<String, VariableInstance> entry : variables.entrySet()) {
                ObjectNode languageNode;
                String name = entry.getKey();
                VariableInstance variableEntity = entry.getValue();
                ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(variableEntity.getExecutionId());
                while (!executionEntity.isScope()) {
                    executionEntity = executionEntity.getParent();
                }
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
                ValuedDataObject foundDataObject = null;
                if (executionEntity.getParentId() == null) {
                    for (ValuedDataObject dataObject : bpmnModel.getMainProcess().getDataObjects()) {
                        if (!dataObject.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject;
                        break;
                    }
                } else {
                    ValuedDataObject dataObject;
                    SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(execution.getActivityId());
                    dataObject = subProcess.getDataObjects().iterator();
                    while (dataObject.hasNext()) {
                        ValuedDataObject dataObject2 = (ValuedDataObject)dataObject.next();
                        if (!dataObject2.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject2;
                        break;
                    }
                }
                String localizedName = null;
                String localizedDescription = null;
                if (this.locale != null && foundDataObject != null && (languageNode = Context.getLocalizationElementProperties(this.locale, foundDataObject.getId(), execution.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
                    JsonNode descriptionNode;
                    JsonNode nameNode = languageNode.get("name");
                    if (nameNode != null) {
                        localizedName = nameNode.asText();
                    }
                    if ((descriptionNode = languageNode.get("description")) != null) {
                        localizedDescription = descriptionNode.asText();
                    }
                }
                if (foundDataObject == null) continue;
                dataObjects.put(name, new DataObjectImpl(variableEntity.getName(), variableEntity.getValue(), foundDataObject.getDocumentation(), foundDataObject.getType(), localizedName, localizedDescription, foundDataObject.getId()));
            }
        }
        return dataObjects;
    }

    public Map<String, VariableInstance> getVariables(ExecutionEntity execution, CommandContext commandContext) {
        Map<String, VariableInstance> variables = null;
        variables = this.dataObjectNames == null || this.dataObjectNames.isEmpty() ? (this.isLocal ? execution.getVariableInstancesLocal() : execution.getVariableInstances()) : (this.isLocal ? execution.getVariableInstancesLocal(this.dataObjectNames, false) : execution.getVariableInstances(this.dataObjectNames, false));
        return variables;
    }
}

