/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.VariablesPropagator;
import org.activiti.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class TriggerCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> processVariables;
    protected Map<String, Object> transientVariables;
    private Map<String, Object> availableVariables;
    private VariablesPropagator variablesPropagator;

    public TriggerCmd(String executionId, Map<String, Object> processVariables) {
        super(executionId);
        this.processVariables = processVariables;
    }

    public TriggerCmd(String executionId, Map<String, Object> processVariables, Map<String, Object> transientVariables) {
        this(executionId, processVariables);
        this.transientVariables = transientVariables;
    }

    public TriggerCmd(String executionId, Map<String, Object> availableVariables, VariablesPropagator variablesPropagator) {
        super(executionId);
        this.availableVariables = availableVariables;
        this.variablesPropagator = variablesPropagator;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        if (this.transientVariables != null) {
            execution.setTransientVariables(this.transientVariables);
        }
        if (this.variablesPropagator != null) {
            this.variablesPropagator.propagate(execution, this.availableVariables);
        }
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivitiySignalledEvent(execution, null, null));
        Context.getAgenda().planTriggerExecutionOperation(execution);
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot trigger an execution that is suspended";
    }
}

