/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.impl.logger;

import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.BaseEntityEventListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.test.impl.logger.DebugInfoExecutionCreated;
import org.activiti.engine.test.impl.logger.DebugInfoExecutionDeleted;
import org.activiti.engine.test.impl.logger.ProcessExecutionLogger;

public class DebugInfoEntityEventListener
extends BaseEntityEventListener {
    protected ProcessExecutionLogger processExecutionLogger;

    public DebugInfoEntityEventListener(ProcessExecutionLogger processExecutionLogger) {
        this.processExecutionLogger = processExecutionLogger;
    }

    @Override
    protected void onCreate(ActivitiEvent event) {
        ExecutionEntity executionEntity = this.getExecutionEntity(event);
        if (executionEntity != null) {
            this.processExecutionLogger.executionCreated(executionEntity);
            this.processExecutionLogger.addDebugInfo(new DebugInfoExecutionCreated(executionEntity));
        }
    }

    @Override
    protected void onDelete(ActivitiEvent event) {
        ExecutionEntity executionEntity = this.getExecutionEntity(event);
        if (executionEntity != null) {
            this.processExecutionLogger.executionDeleted(executionEntity);
            this.processExecutionLogger.addDebugInfo(new DebugInfoExecutionDeleted(executionEntity));
        }
    }

    protected ExecutionEntity getExecutionEntity(ActivitiEvent event) {
        ActivitiEntityEvent entityEvent = (ActivitiEntityEvent)event;
        Object entity = entityEvent.getEntity();
        if (entity instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)entity;
            return executionEntity;
        }
        return null;
    }
}

