/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.MappingExecutionContext;
import org.activiti.engine.impl.bpmn.behavior.VariablesCalculator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class VariablesPropagator {
    private ExecutionEntityManager executionEntityManager;
    private final VariablesCalculator variablesCalculator;

    public VariablesPropagator(VariablesCalculator variablesCalculator) {
        this.variablesCalculator = variablesCalculator;
    }

    public void propagate(DelegateExecution execution, Map<String, Object> availableVariables) {
        if (availableVariables != null && !availableVariables.isEmpty()) {
            if (execution.getParent().isMultiInstanceRoot()) {
                execution.setVariablesLocal(availableVariables);
            } else if (execution.getProcessInstanceId() != null) {
                ExecutionEntity processInstanceEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(execution.getProcessInstanceId());
                processInstanceEntity.setVariables(this.variablesCalculator.calculateOutPutVariables(MappingExecutionContext.buildMappingExecutionContext(execution), availableVariables));
            }
        }
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        if (this.executionEntityManager == null) {
            this.executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        }
        return this.executionEntityManager;
    }
}

