/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BaseExecutionListener;
import org.activiti.engine.delegate.BaseTaskListener;
import org.activiti.engine.delegate.CustomPropertiesResolver;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.TransactionDependentExecutionListener;
import org.activiti.engine.delegate.TransactionDependentTaskListener;
import org.activiti.engine.impl.bpmn.listener.ExecuteExecutionListenerTransactionListener;
import org.activiti.engine.impl.bpmn.listener.ExecuteTaskListenerTransactionListener;
import org.activiti.engine.impl.bpmn.listener.TransactionDependentExecutionListenerExecutionScope;
import org.activiti.engine.impl.bpmn.listener.TransactionDependentTaskListenerExecutionScope;
import org.activiti.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.invocation.TaskListenerInvocation;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;

public class ListenerNotificationHelper {
    public void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, DelegateExecution execution, String eventType) {
        List listeners = elementWithExecutionListeners.getExecutionListeners();
        if (listeners != null && listeners.size() > 0) {
            ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
            for (ActivitiListener activitiListener : listeners) {
                if (!eventType.equals(activitiListener.getEvent())) continue;
                BaseExecutionListener executionListener = null;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = activitiListener.getOnTransaction() != null ? listenerFactory.createTransactionDependentDelegateExpressionExecutionListener(activitiListener) : listenerFactory.createDelegateExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = (ExecutionListener)activitiListener.getInstance();
                }
                if (executionListener == null) continue;
                if (activitiListener.getOnTransaction() != null) {
                    this.planTransactionDependentExecutionListener(listenerFactory, execution, (TransactionDependentExecutionListener)executionListener, activitiListener);
                    continue;
                }
                execution.setEventName(eventType);
                execution.setCurrentActivitiListener(activitiListener);
                executionListener.notify(execution);
                execution.setEventName(null);
                execution.setCurrentActivitiListener(null);
            }
        }
    }

    protected void planTransactionDependentExecutionListener(ListenerFactory listenerFactory, DelegateExecution execution, TransactionDependentExecutionListener executionListener, ActivitiListener activitiListener) {
        Map<String, Object> executionVariablesToUse = execution.getVariables();
        CustomPropertiesResolver customPropertiesResolver = this.createCustomPropertiesResolver(activitiListener);
        Map<String, Object> customPropertiesMapToUse = this.invokeCustomPropertiesResolver(execution, customPropertiesResolver);
        TransactionDependentExecutionListenerExecutionScope scope = new TransactionDependentExecutionListenerExecutionScope(execution.getProcessInstanceId(), execution.getId(), execution.getCurrentFlowElement(), executionVariablesToUse, customPropertiesMapToUse);
        this.addTransactionListener(activitiListener, new ExecuteExecutionListenerTransactionListener(executionListener, scope));
    }

    public void executeTaskListeners(TaskEntity taskEntity, String eventType) {
        Process process;
        FlowElement flowElement;
        if (taskEntity.getProcessDefinitionId() != null && (flowElement = (process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId())).getFlowElement(taskEntity.getTaskDefinitionKey(), true)) instanceof UserTask) {
            UserTask userTask = (UserTask)flowElement;
            this.executeTaskListeners(userTask, taskEntity, eventType);
        }
    }

    public void executeTaskListeners(UserTask userTask, TaskEntity taskEntity, String eventType) {
        for (ActivitiListener activitiListener : userTask.getTaskListeners()) {
            String event = activitiListener.getEvent();
            if (!event.equals(eventType) && !event.equals("all")) continue;
            BaseTaskListener taskListener = this.createTaskListener(activitiListener);
            if (activitiListener.getOnTransaction() != null) {
                this.planTransactionDependentTaskListener(taskEntity.getExecution(), (TransactionDependentTaskListener)taskListener, activitiListener);
                continue;
            }
            taskEntity.setEventName(eventType);
            taskEntity.setCurrentActivitiListener(activitiListener);
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)taskListener, taskEntity));
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
            finally {
                taskEntity.setEventName(null);
                taskEntity.setCurrentActivitiListener(null);
            }
        }
    }

    protected BaseTaskListener createTaskListener(ActivitiListener activitiListener) {
        BaseTaskListener taskListener = null;
        ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = listenerFactory.createClassDelegateTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = listenerFactory.createExpressionTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = activitiListener.getOnTransaction() != null ? listenerFactory.createTransactionDependentDelegateExpressionTaskListener(activitiListener) : listenerFactory.createDelegateExpressionTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = (TaskListener)activitiListener.getInstance();
        }
        return taskListener;
    }

    protected void planTransactionDependentTaskListener(DelegateExecution execution, TransactionDependentTaskListener taskListener, ActivitiListener activitiListener) {
        Map<String, Object> executionVariablesToUse = execution.getVariables();
        CustomPropertiesResolver customPropertiesResolver = this.createCustomPropertiesResolver(activitiListener);
        Map<String, Object> customPropertiesMapToUse = this.invokeCustomPropertiesResolver(execution, customPropertiesResolver);
        TransactionDependentTaskListenerExecutionScope scope = new TransactionDependentTaskListenerExecutionScope(execution.getProcessInstanceId(), execution.getId(), (Task)execution.getCurrentFlowElement(), executionVariablesToUse, customPropertiesMapToUse);
        this.addTransactionListener(activitiListener, new ExecuteTaskListenerTransactionListener(taskListener, scope));
    }

    protected CustomPropertiesResolver createCustomPropertiesResolver(ActivitiListener activitiListener) {
        CustomPropertiesResolver customPropertiesResolver = null;
        ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createClassDelegateCustomPropertiesResolver(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createExpressionCustomPropertiesResolver(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createDelegateExpressionCustomPropertiesResolver(activitiListener);
        }
        return customPropertiesResolver;
    }

    protected Map<String, Object> invokeCustomPropertiesResolver(DelegateExecution execution, CustomPropertiesResolver customPropertiesResolver) {
        Map<String, Object> customPropertiesMapToUse = null;
        if (customPropertiesResolver != null) {
            customPropertiesMapToUse = customPropertiesResolver.getCustomPropertiesMap(execution);
        }
        return customPropertiesMapToUse;
    }

    protected void addTransactionListener(ActivitiListener activitiListener, TransactionListener transactionListener) {
        TransactionContext transactionContext = Context.getTransactionContext();
        if ("before-commit".equals(activitiListener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.COMMITTING, transactionListener);
        } else if ("committed".equals(activitiListener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.COMMITTED, transactionListener);
        } else if ("rolled-back".equals(activitiListener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.ROLLED_BACK, transactionListener);
        }
    }
}

