/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.DelegationState;

public class ResolveTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public ResolveTaskCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public ResolveTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.variables != null) {
            task.setVariables(this.variables);
        }
        if (this.transientVariables != null) {
            task.setTransientVariables(this.transientVariables);
        }
        task.setDelegationState(DelegationState.RESOLVED);
        commandContext.getTaskEntityManager().changeTaskAssignee(task, task.getOwner());
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot resolve a suspended task";
    }
}

