/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.delegate;

import java.util.Map;
import java.util.Optional;

public class ThrowMessage {
    private String name;
    private Optional<Map<String, Object>> payload = Optional.empty();
    private Optional<String> businessKey = Optional.empty();
    private Optional<String> correlationKey = Optional.empty();

    private ThrowMessage(ThrowMessagBuilder builder) {
        this.name = builder.name;
        this.payload = builder.payload;
        this.businessKey = builder.businessKey;
        this.correlationKey = builder.correlationKey;
    }

    ThrowMessage() {
    }

    public ThrowMessage(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Map<String, Object>> getPayload() {
        return this.payload;
    }

    public Optional<String> getBusinessKey() {
        return this.businessKey;
    }

    public Optional<String> getCorrelationKey() {
        return this.correlationKey;
    }

    public static INameStage builder() {
        return new ThrowMessagBuilder();
    }

    public static final class ThrowMessagBuilder
    implements INameStage,
    IBuildStage {
        private String name;
        private Optional<Map<String, Object>> payload = Optional.empty();
        private Optional<String> businessKey = Optional.empty();
        private Optional<String> correlationKey = Optional.empty();

        private ThrowMessagBuilder() {
        }

        @Override
        public IBuildStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IBuildStage payload(Optional<Map<String, Object>> payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public IBuildStage businessKey(Optional<String> businessKey) {
            this.businessKey = businessKey;
            return this;
        }

        @Override
        public IBuildStage correlationKey(Optional<String> correlationKey) {
            this.correlationKey = correlationKey;
            return this;
        }

        @Override
        public ThrowMessage build() {
            return new ThrowMessage(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage payload(Optional<Map<String, Object>> var1);

        public IBuildStage businessKey(Optional<String> var1);

        public IBuildStage correlationKey(Optional<String> var1);

        public ThrowMessage build();
    }

    public static interface INameStage {
        public IBuildStage name(String var1);
    }
}

