/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiEngineAgenda;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.ApplicationStatusHolder;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.activiti.engine.impl.persistence.cache.EntityCache;
import org.activiti.engine.impl.persistence.entity.AttachmentEntityManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntityManager;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntityManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.EventLogEntryEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.ModelEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.activiti.engine.impl.persistence.entity.PropertyEntityManager;
import org.activiti.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntityManager;
import org.activiti.engine.impl.persistence.entity.TableDataManager;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.TimerJobEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static Logger log = LoggerFactory.getLogger(CommandContext.class);
    protected Command<?> command;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected List<CommandContextCloseListener> closeListeners;
    protected Map<String, Object> attributes;
    protected boolean reused;
    protected ActivitiEngineAgenda agenda;
    protected Map<String, ExecutionEntity> involvedExecutions = new HashMap<String, ExecutionEntity>(1);
    protected LinkedList<Object> resultStack = new LinkedList();

    public CommandContext(Command<?> command, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.command = command;
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.agenda = processEngineConfiguration.getEngineAgendaFactory().createAgenda(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block25: {
            try {
                try {
                    try {
                        this.executeCloseListenersClosing();
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block25;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.executeCloseListenersAfterSessionFlushed();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                this.logException();
                                this.executeCloseListenersCloseFailure();
                            } else {
                                this.executeCloseListenersClosed();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.executeCloseListenersAfterSessionFlushed();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        this.logException();
                        this.executeCloseListenersCloseFailure();
                    } else {
                        this.executeCloseListenersClosed();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        this.rethrowExceptionIfNeeded();
    }

    protected void logException() {
        if (this.exception instanceof JobNotFoundException || this.exception instanceof ActivitiTaskAlreadyClaimedException) {
            log.info("Error while closing command context", this.exception);
        } else if (this.exception instanceof ActivitiOptimisticLockingException) {
            log.debug("Optimistic locking exception : " + String.valueOf(this.exception));
        } else if (ApplicationStatusHolder.isShutdownInProgress()) {
            log.warn("Error while closing command context", this.exception);
        } else if (this.exception instanceof BpmnError || this.exception instanceof ActivitiException) {
            log.warn("Error while closing command context", this.exception);
        } else {
            log.error("Error while closing command context", this.exception);
        }
    }

    protected void rethrowExceptionIfNeeded() throws Error {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new ActivitiException("exception while executing command " + String.valueOf(this.command), this.exception);
    }

    public void addCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CommandContextCloseListener>(1);
        }
        this.closeListeners.add(commandContextCloseListener);
    }

    public List<CommandContextCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    public boolean hasCloseListener(Class<?> type) {
        if (this.closeListeners != null && this.closeListeners.size() != 0) {
            for (CommandContextCloseListener listener : this.closeListeners) {
                if (!type.isInstance(listener)) continue;
                return true;
            }
        }
        return false;
    }

    protected void executeCloseListenersClosing() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closing(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersAfterSessionFlushed() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.afterSessionsFlush(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersClosed() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closed(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void executeCloseListenersCloseFailure() {
        if (this.closeListeners != null) {
            try {
                for (CommandContextCloseListener listener : this.closeListeners) {
                    listener.closeFailure(this);
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
            LogMDC.clear();
        }
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getGenericAttribute(String key) {
        if (this.attributes != null) {
            return (T)this.getAttribute(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new ActivitiException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    public DeploymentEntityManager getDeploymentEntityManager() {
        return this.processEngineConfiguration.getDeploymentEntityManager();
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.processEngineConfiguration.getResourceEntityManager();
    }

    public ByteArrayEntityManager getByteArrayEntityManager() {
        return this.processEngineConfiguration.getByteArrayEntityManager();
    }

    public ProcessDefinitionEntityManager getProcessDefinitionEntityManager() {
        return this.processEngineConfiguration.getProcessDefinitionEntityManager();
    }

    public ModelEntityManager getModelEntityManager() {
        return this.processEngineConfiguration.getModelEntityManager();
    }

    public ProcessDefinitionInfoEntityManager getProcessDefinitionInfoEntityManager() {
        return this.processEngineConfiguration.getProcessDefinitionInfoEntityManager();
    }

    public ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }

    public TaskEntityManager getTaskEntityManager() {
        return this.processEngineConfiguration.getTaskEntityManager();
    }

    public IdentityLinkEntityManager getIdentityLinkEntityManager() {
        return this.processEngineConfiguration.getIdentityLinkEntityManager();
    }

    public VariableInstanceEntityManager getVariableInstanceEntityManager() {
        return this.processEngineConfiguration.getVariableInstanceEntityManager();
    }

    public HistoricProcessInstanceEntityManager getHistoricProcessInstanceEntityManager() {
        return this.processEngineConfiguration.getHistoricProcessInstanceEntityManager();
    }

    public HistoricDetailEntityManager getHistoricDetailEntityManager() {
        return this.processEngineConfiguration.getHistoricDetailEntityManager();
    }

    public HistoricVariableInstanceEntityManager getHistoricVariableInstanceEntityManager() {
        return this.processEngineConfiguration.getHistoricVariableInstanceEntityManager();
    }

    public HistoricActivityInstanceEntityManager getHistoricActivityInstanceEntityManager() {
        return this.processEngineConfiguration.getHistoricActivityInstanceEntityManager();
    }

    public HistoricTaskInstanceEntityManager getHistoricTaskInstanceEntityManager() {
        return this.processEngineConfiguration.getHistoricTaskInstanceEntityManager();
    }

    public HistoricIdentityLinkEntityManager getHistoricIdentityLinkEntityManager() {
        return this.processEngineConfiguration.getHistoricIdentityLinkEntityManager();
    }

    public EventLogEntryEntityManager getEventLogEntryEntityManager() {
        return this.processEngineConfiguration.getEventLogEntryEntityManager();
    }

    public JobEntityManager getJobEntityManager() {
        return this.processEngineConfiguration.getJobEntityManager();
    }

    public TimerJobEntityManager getTimerJobEntityManager() {
        return this.processEngineConfiguration.getTimerJobEntityManager();
    }

    public SuspendedJobEntityManager getSuspendedJobEntityManager() {
        return this.processEngineConfiguration.getSuspendedJobEntityManager();
    }

    public DeadLetterJobEntityManager getDeadLetterJobEntityManager() {
        return this.processEngineConfiguration.getDeadLetterJobEntityManager();
    }

    public AttachmentEntityManager getAttachmentEntityManager() {
        return this.processEngineConfiguration.getAttachmentEntityManager();
    }

    public TableDataManager getTableDataManager() {
        return this.processEngineConfiguration.getTableDataManager();
    }

    public CommentEntityManager getCommentEntityManager() {
        return this.processEngineConfiguration.getCommentEntityManager();
    }

    public PropertyEntityManager getPropertyEntityManager() {
        return this.processEngineConfiguration.getPropertyEntityManager();
    }

    public EventSubscriptionEntityManager getEventSubscriptionEntityManager() {
        return this.processEngineConfiguration.getEventSubscriptionEntityManager();
    }

    public HistoryManager getHistoryManager() {
        return this.processEngineConfiguration.getHistoryManager();
    }

    public JobManager getJobManager() {
        return this.processEngineConfiguration.getJobManager();
    }

    public void addInvolvedExecution(ExecutionEntity executionEntity) {
        if (executionEntity.getId() != null) {
            this.involvedExecutions.put(executionEntity.getId(), executionEntity);
        }
    }

    public boolean hasInvolvedExecutions() {
        return this.involvedExecutions.size() > 0;
    }

    public Collection<ExecutionEntity> getInvolvedExecutions() {
        return this.involvedExecutions.values();
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public ActivitiEventDispatcher getEventDispatcher() {
        return this.processEngineConfiguration.getEventDispatcher();
    }

    public ActivitiEngineAgenda getAgenda() {
        return this.agenda;
    }

    public Object getResult() {
        return this.resultStack.pollLast();
    }

    public void setResult(Object result) {
        this.resultStack.add(result);
    }

    public boolean isReused() {
        return this.reused;
    }

    public void setReused(boolean reused) {
        this.reused = reused;
    }
}

