/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event.impl;

import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.ActivitiProcessStartedEvent;
import org.activiti.engine.delegate.event.impl.ActivitiEntityWithVariablesEventImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ActivitiProcessStartedEventImpl
extends ActivitiEntityWithVariablesEventImpl
implements ActivitiProcessStartedEvent {
    protected final String nestedProcessInstanceId;
    protected final String nestedProcessDefinitionId;
    protected final String linkedProcessInstanceId;
    protected final String linkedProcessInstanceType;

    public ActivitiProcessStartedEventImpl(Object entity, Map variables, boolean localScope) {
        this(entity, variables, localScope, null, null);
    }

    public ActivitiProcessStartedEventImpl(Object entity, Map variables, boolean localScope, String linkedProcessInstanceId, String linkedProcessInstanceType) {
        super(entity, variables, localScope, ActivitiEventType.PROCESS_STARTED);
        if (entity instanceof ExecutionEntity) {
            ExecutionEntity superExecution;
            ExecutionEntity executionEntity = (ExecutionEntity)entity;
            if (!executionEntity.isProcessInstanceType()) {
                executionEntity = executionEntity.getParent();
            }
            if ((superExecution = executionEntity.getSuperExecution()) != null) {
                this.nestedProcessDefinitionId = superExecution.getProcessDefinitionId();
                this.nestedProcessInstanceId = superExecution.getProcessInstanceId();
            } else {
                this.nestedProcessDefinitionId = null;
                this.nestedProcessInstanceId = null;
            }
        } else {
            this.nestedProcessDefinitionId = null;
            this.nestedProcessInstanceId = null;
        }
        this.linkedProcessInstanceId = linkedProcessInstanceId;
        this.linkedProcessInstanceType = linkedProcessInstanceType;
    }

    @Override
    public String getNestedProcessInstanceId() {
        return this.nestedProcessInstanceId;
    }

    @Override
    public String getNestedProcessDefinitionId() {
        return this.nestedProcessDefinitionId;
    }

    @Override
    public String getLinkedProcessInstanceId() {
        return this.linkedProcessInstanceId;
    }

    @Override
    public String getLinkedProcessInstanceType() {
        return this.linkedProcessInstanceType;
    }
}

