/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;

public class SignalEventDefinitionParseHandler
extends AbstractBpmnParseHandler<SignalEventDefinition> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SignalEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SignalEventDefinition signalDefinition) {
        Signal signal = null;
        if (bpmnParse.getBpmnModel().containsSignalId(signalDefinition.getSignalRef())) {
            signal = bpmnParse.getBpmnModel().getSignal(signalDefinition.getSignalRef());
        }
        if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement();
            intermediateCatchEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateCatchSignalEventActivityBehavior(intermediateCatchEvent, signalDefinition, signal));
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boundaryEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createBoundarySignalEventActivityBehavior(boundaryEvent, signalDefinition, signal, boundaryEvent.isCancelActivity()));
        }
    }
}

