/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.math.BigDecimal;
import java.util.Optional;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class BigDecimalType
implements VariableType {
    @Override
    public String getTypeName() {
        return "bigdecimal";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return Optional.ofNullable(valueFields).map(ValueFields::getTextValue).map(BigDecimal::new).orElse(null);
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        String textValue = Optional.ofNullable(value).map(Object::toString).orElse(null);
        valueFields.setTextValue(textValue);
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return Optional.ofNullable(value).map(Object::getClass).map(BigDecimal.class::isAssignableFrom).orElse(true);
    }
}

